/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.platform;

import de.z0rdak.yawp.api.events.region.FabricRegionEvents;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.config.server.LoggingConfig;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.config.server.RegionConfig;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.platform.services.IConfigHelper;
import fuzs.forgeconfigapiport.fabric.api.v5.ConfigRegistry;
import fuzs.forgeconfigapiport.fabric.api.v5.ModConfigEvents;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class FabricConfigHelper
implements IConfigHelper {
    @Override
    public void registerServerConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.SERVER, configName);
    }

    @Override
    public void registerClientConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.CLIENT, configName);
    }

    @Override
    public void registerCommonConfig(ModConfigSpec spec, String configName) {
        this.registerModConfig(spec, ModConfig.Type.COMMON, configName);
    }

    private void registerModConfig(ModConfigSpec spec, ModConfig.Type type, String configName) {
        ConfigRegistry.INSTANCE.register("yawp", type, (IConfigSpec)spec, configName);
    }

    @Override
    public void register() {
        ModConfigEvents.loading((String)"yawp").register(FabricConfigHelper::onModLoading);
        ModConfigEvents.reloading((String)"yawp").register(FabricConfigHelper::onModReloading);
        Services.CONFIG_REGISTRY.registerServerConfig(PermissionConfig.CONFIG_SPEC, "yawp-common.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(FlagConfig.CONFIG_SPEC, "yawp-flags.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(RegionConfig.CONFIG_SPEC, "yawp-region-defaults.toml");
        Services.CONFIG_REGISTRY.registerServerConfig(LoggingConfig.CONFIG_SPEC, "yawp-logging.toml");
    }

    private static void onModReloading(ModConfig modConfig) {
        if (modConfig.getModId().equals("yawp")) {
            de.z0rdak.yawp.config.ConfigRegistry.onModReloaded(modConfig.getFileName(), () -> {});
        }
    }

    private static void onModLoading(ModConfig modConfig) {
        if (modConfig.getModId().equals("yawp")) {
            Runnable registerHandler = () -> {
                if (LoggingConfig.shouldLogFlagChecks()) {
                    FabricRegionEvents.CHECK_FLAG.register(LoggingConfig::logCheck);
                }
                if (LoggingConfig.shouldLogFlagCheckResults()) {
                    FabricRegionEvents.FLAG_RESULT.register(LoggingConfig::logResult);
                }
            };
            de.z0rdak.yawp.config.ConfigRegistry.onModLoaded(modConfig.getFileName(), registerHandler);
        }
    }
}

