package de.z0rdak.yawp.core.area;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.*;
import net.minecraft.class_2960;

public final class BlockDisplayProperties {

    public static final boolean DEFAULT_GLOW = true;
    public static final int DEFAULT_LIGHT_LEVEL = 15;

    public static final List<class_2960> DEFAULT_BLOCKS = new ArrayList<>();
    static {
        DEFAULT_BLOCKS.add(class_2960.method_60656("white_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("orange_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("magenta_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("light_blue_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("yellow_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("lime_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("pink_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("gray_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("light_gray_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("cyan_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("purple_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("blue_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("brown_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("green_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("red_stained_glass"));
        DEFAULT_BLOCKS.add(class_2960.method_60656("black_stained_glass"));
    }

    public static class_2960 randomFromDefault() {
        int randomNum = new Random().nextInt(0, 16);
        return BlockDisplayProperties.DEFAULT_BLOCKS.get(randomNum);
    }

    public static MapCodec<BlockDisplayProperties> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
                    class_2960.field_25139.fieldOf("block").orElse(randomFromDefault())
                            .forGetter(BlockDisplayProperties::blockRl),
                    Codec.BOOL.fieldOf("hasGlow").orElse(DEFAULT_GLOW)
                            .forGetter(BlockDisplayProperties::hasGlow),
                    Codec.INT.fieldOf("lightLevel").orElse(DEFAULT_LIGHT_LEVEL)
                            .forGetter(BlockDisplayProperties::lightLevel)
            ).apply(instance, BlockDisplayProperties::new)
    );

    private class_2960 blockRl;
    private boolean hasGlow;
    private int lightLevel;
    // private boolean persistent;

    public BlockDisplayProperties(class_2960 blockRl, boolean hasGlow, int lightLevel) {
        this.blockRl = blockRl;
        this.hasGlow = hasGlow;
        this.lightLevel = lightLevel;
        //this.persistent = true;
    }

    public class_2960 blockRl() {
        return this.blockRl;
    }

    public boolean hasGlow() {
        return this.hasGlow;
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public void setBlockRl(class_2960 blockRl) {
        this.blockRl = blockRl;
    }

    public void setHasGlow(boolean hasGlow) {
        this.hasGlow = hasGlow;
    }

    public void setLightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
    }
}
