/**
 * Credit: Peter Svensson for the initial implementation
 */
package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_5362;

public class ExplosionDamageCalculatorInterceptor extends class_5362 {
	protected class_5362 nextBehavior;
	protected class_1937 level;
	
	public ExplosionDamageCalculatorInterceptor(class_5362 nextBehavior, class_1937 level) 
	{
		this.nextBehavior = nextBehavior;
		this.level = level;
	}
	
	@Override
	public boolean method_29554(class_1927 explosion, class_1922 blockGetter, class_2338 pos, class_2680 state, float power) {
		RegionFlag flag = switch (explosion.getIndirectSourceEntity()) {
			case Creeper c -> RegionFlag.EXPLOSION_CREEPER_BLOCK;
			// case Player p -> RegionFlag.EXPLOSION_PLAYER_BLOCK;
			case null, default -> RegionFlag.EXPLOSION_BLOCK; // is null for dispenser etc
		};
		FlagCheckEvent checkEvent = new FlagCheckEvent(pos, flag, this.level.dimension());
		FlagState flagState = FlagEvaluator.processCheck(checkEvent);
		return flagState == FlagState.DENIED 
				? false : nextBehavior.shouldBlockExplode(explosion, blockGetter, pos, state, power);
	}

	@Override
	public boolean method_55504(class_1927 explosion, class_1297 entity) {
		RegionFlag flag = switch (explosion.getIndirectSourceEntity()) {
			case Creeper c -> RegionFlag.EXPLOSION_CREEPER_ENTITY;
			case null, default -> RegionFlag.EXPLOSION_ENTITY;
		};
		FlagCheckEvent checkEvent = new FlagCheckEvent(entity.blockPosition(), flag, explosion.level().dimension());
		FlagState flagState = FlagEvaluator.processCheck(checkEvent);
		return flagState == FlagState.DENIED
				? false : nextBehavior.shouldDamageEntity(explosion, entity);
	}

	// Since we don't have a reference here from the explosion to determine the source entity, 
	// we just go with the fact that if any of the two flags are denied we prevent knockback
	@Override
	public float method_57007(class_1297 entity) {
		FlagCheckEvent checkExplosionEntityFlag = new FlagCheckEvent(entity.method_24515(), RegionFlag.EXPLOSION_ENTITY, entity.method_73183().method_27983());
		FlagCheckEvent checkCreeperExplosionEntityFlag = new FlagCheckEvent(entity.method_24515(), RegionFlag.EXPLOSION_CREEPER_ENTITY, entity.method_73183().method_27983());
		FlagState flagState1 = FlagEvaluator.processCheck(checkExplosionEntityFlag);
		FlagState flagState2 = FlagEvaluator.processCheck(checkCreeperExplosionEntityFlag);
		return flagState1 == FlagState.DENIED || flagState2 == FlagState.DENIED
				? 0	: nextBehavior.method_57007(entity);
	}
	
	// Note: All other method implementations pass the call directly to the underlying ExplosionDamageCalculator
	
	@Override		
	public @NotNull Optional<Float> method_29555(class_1927 explosion, class_1922 blockGetter, class_2338 pos, class_2680 blockState, class_3610 fluidState) {
		return nextBehavior.method_29555(explosion, blockGetter, pos, blockState, fluidState);
	}

	@Override
	public float method_55115(class_1927 explosion, class_1297 entity, float amount) {
		return nextBehavior.method_55115(explosion, entity, amount);
	}
}
