package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.api.commands.CommandConstants.*;
import static de.z0rdak.yawp.api.commands.Commands.*;
import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.*;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.field_11750;
import static net.minecraft.class_2558.class_2559.field_11745;

public class RegionStateMessage implements MultiLineMessage<IProtectedRegion> {

    private final IProtectedRegion region;
    private final List<class_2561> regionState;

    public RegionStateMessage(IProtectedRegion region) {
        this.region = region;
        this.regionState = new ArrayList<>();
    }

    public static RegionStateMessage of(IProtectedRegion region) {
        return new RegionStateMessage(region);
    }

    public static class_5250 buildRegionStateLink(IProtectedRegion region) {
        class_5250 linkText = class_2561.method_48321("cli.msg.info.region.state.link.text", "State");
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.state.link.hover", "Show region state for %s", region.getName());
        String cmd = buildRegionStateCmd(region);
        return buildExecuteCmdLink(linkText, hoverText, cmd, field_11750, LINK_COLOR);
    }

    public static class_5250 buildRegionRenameLink(IMarkableRegion region) {
        String cmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), RENAME.toString(), "");
        class_5250 text = class_2561.method_48321("cli.msg.info.region.state.rename.link.text", "rename");
        class_5250 hover = class_2561.method_48322("cli.msg.info.region.state.rename.link.hover", "Rename region '%s'", region.getName());
        return buildExecuteCmdLink(text, hover, cmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildRegionPriorityComponent(IMarkableRegion region) {
        int defaultPriorityInc = Services.REGION_CONFIG.getDefaultPriorityInc();
        String incPriorityCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), STATE.toString(), PRIORITY.toString(), INC.toString(), String.valueOf(defaultPriorityInc));
        class_5250 incLinkText = class_2561.method_48322("cli.msg.info.region.state.priority.increase.link.text", "+%s", defaultPriorityInc);
        class_5250 incHoverText = class_2561.method_48322("cli.msg.info.region.state.priority.increase.link.hover", "Increase region priority by %s", defaultPriorityInc);
        class_5250 increaseLink = buildExecuteCmdComponent(incLinkText, incHoverText, incPriorityCmd, field_11750, ADD_CMD_COLOR);
        String decPriorityCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), STATE.toString(), PRIORITY.toString(), DEC.toString(), String.valueOf(defaultPriorityInc));
        class_5250 decLinkText = class_2561.method_48322("cli.msg.info.region.state.priority.decrease.link.text", "+%s", defaultPriorityInc);
        class_5250 decHoverText = class_2561.method_48322("cli.msg.info.region.state.priority.decrease.link.hover", "Decrease region priority by %s", defaultPriorityInc);
        class_5250 decreaseLink = buildExecuteCmdComponent(decLinkText, decHoverText, decPriorityCmd, field_11750, REMOVE_CMD_COLOR);
        String setPriorityCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), STATE.toString(), PRIORITY.toString(), "");
        class_5250 setPriorityLinkText = class_2561.method_48322("cli.msg.info.region.state.priority.set.link.text", "%s", region.getPriority());
        class_5250 setPriorityHoverText = class_2561.method_48321("cli.msg.info.region.state.priority.set.link.hover", "Set priority for region");
        class_5250 setPriorityLink = buildExecuteCmdComponent(setPriorityLinkText, setPriorityHoverText, setPriorityCmd, field_11745, LINK_COLOR);
        return Messages.substitutable("%s %s %s", setPriorityLink, increaseLink, decreaseLink);
    }

    public static class_5250 buildAllLocalAlertToggleLink(IProtectedRegion dimRegion) {
        class_5250 enableLinkTextKey = class_2561.method_48321("cli.msg.info.region.state.enable.all.true.link.text", "all-on");
        class_5250 enableHoverTextKey = class_2561.method_48322("cli.msg.info.region.state.enable.all.true.link.hover", "Enables alert for all local regions of %s", dimRegion.getName());
        class_5250 disableLinkTextKey = class_2561.method_48321("cli.msg.info.region.state.enable.all.false.link.text", "all-off");
        class_5250 disableHoverTextKey = class_2561.method_48322("cli.msg.info.region.state.enable.all.false.link.hover", "Disables alert for all local regions of %s", dimRegion.getName());
        String enableCmd = buildCommandStr(DIM.toString(), dimRegion.getName(), STATE.toString(), ALERT_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = buildCommandStr(DIM.toString(), dimRegion.getName(), STATE.toString(), ALERT_LOCAL.toString(), Boolean.FALSE.toString());
        class_5250 activeAlertLink = buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, field_11750, field_1060);
        class_5250 disableAlertLink = buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, field_11750, field_1061);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static class_5250 buildAllLocalEnableComponent(IProtectedRegion dimRegion) {
        class_5250 enableLinkTextKey = class_2561.method_48321("cli.msg.info.region.state.alert.all.true.link.text", "all-on");
        class_5250 enableHoverTextKey = class_2561.method_48322("cli.msg.info.region.state.alert.all.true.link.hover", "Activates all local regions of %s", dimRegion.getName());
        class_5250 disableLinkTextKey = class_2561.method_48321("cli.msg.info.region.state.alert.all.false.link.text", "all-off");
        class_5250 disableHoverTextKey = class_2561.method_48322("cli.msg.info.region.state.alert.all.false.link.hover", "Disables all local regions of %s", dimRegion.getName());
        String enableCmd = buildCommandStr(DIM.toString(), dimRegion.getName(), STATE.toString(), ENABLE_LOCAL.toString(), Boolean.TRUE.toString());
        String disableCmd = buildCommandStr(DIM.toString(), dimRegion.getName(), STATE.toString(), ENABLE_LOCAL.toString(), Boolean.FALSE.toString());
        class_5250 activeAlertLink = buildExecuteCmdComponent(enableLinkTextKey, enableHoverTextKey, enableCmd, field_11750, field_1060);
        class_5250 disableAlertLink = buildExecuteCmdComponent(disableLinkTextKey, disableHoverTextKey, disableCmd, field_11750, field_1061);
        return Messages.substitutable("%s %s", activeAlertLink, disableAlertLink);
    }

    public static class_5250 buildRegionEnableComponent(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.enable." + region.isActive() + ".link.text";
        String linkFallback = region.isActive() ? "yes" : "no";
        String hoverTextKey = "cli.msg.info.region.state.enable." + !region.isActive() + ".link.hover";
        String hoverFallback = !region.isActive() ? "Enable flag checks" : "Disable flag checks";
        class_5250 linkText = class_2561.method_48321(linkTextKey, linkFallback);
        class_5250 hoverText = class_2561.method_48321(hoverTextKey, hoverFallback);
        class_124 color = region.isActive() ? field_1060 : field_1080;
        String cmd = buildRegionStateEnableToggleCmd(region);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, color);
    }

    public static class_5250 buildRegionAlertToggleLink(IProtectedRegion region) {
        String linkTextKey = "cli.msg.info.region.state.alert." + !region.isMuted() + ".link.text";
        String hoverTextKey = "cli.msg.info.region.state.alert." + region.isMuted() + ".link.hover";
        String linkFallback = region.isMuted() ? "off" : "on";
        String hoverFallback = !region.isMuted() ? "Turn flag alerts off" : "Turn flag alerts on";
        class_5250 linkText = class_2561.method_48321(linkTextKey, linkFallback);
        class_5250 hoverText = class_2561.method_48321(hoverTextKey, hoverFallback);
        class_124 color = region.isMuted() ? field_1080 : field_1060;
        String cmd = buildRegionStateAlertToggleCmd(region);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, color);
    }

    @Override
    public IProtectedRegion getContent() {
        return this.region;
    }

    /**
     * Builds lines representing the region state
     *
     * @return lines to representing region state
     */
    @Override
    public List<class_2561> getLines() {
        // == [state] for [<name>] ==
        class_5250 header = buildHeader(class_2561.method_48322("cli.msg.info.header.for", "== %s for %s ==", buildRegionStateLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)));
        this.regionState.add(header);
        class_5250 regionEnableComponent = buildRegionEnableComponent(this.region);
        class_5250 regionAlertComponent = buildRegionAlertToggleLink(this.region);
        if (this.region.getRegionType() == RegionType.DIMENSION) {
            // [true|false] | [all-off] [all-on]
            class_5250 enableComp = Messages.substitutable("%s | %s", regionEnableComponent, buildAllLocalEnableComponent(this.region));
            // [on|off] | [all-off] [all-on]
            class_5250 alertComp = Messages.substitutable("%s | %s", regionAlertComponent, buildAllLocalAlertToggleLink(this.region));
            this.regionState.add(buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", enableComp));
            this.regionState.add(buildInfoComponent("cli.msg.info.region.state.alert", "Alert", alertComp));
            return this.regionState;
        }
        if (this.region.getRegionType() == RegionType.LOCAL) {
            IMarkableRegion localRegion = (IMarkableRegion) this.region;
            // Name: [<region-name>]
            class_5250 name = buildInfoComponent("cli.msg.info.region.state.name", "Name", buildRegionRenameLink(localRegion));
            // Priority: <priority> [#][+ 5][- 5]
            class_5250 priority = buildInfoComponent("cli.msg.info.region.state.priority", "Priority", buildRegionPriorityComponent(localRegion));
            this.regionState.add(name);
            this.regionState.add(priority);
        }
        class_5250 enableComp = buildInfoComponent("cli.msg.info.region.state.enable", "Enabled", regionEnableComponent);
        class_5250 alertComp = buildInfoComponent("cli.msg.info.region.state.alert", "Alert", regionAlertComponent);
        // Enabled: [yes], Alert: [on]
        this.regionState.add(Messages.substitutable("%s, %s", enableComp, alertComp));
        return this.regionState;
    }
}
