package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.text.Messages;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.api.commands.Commands.*;
import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.*;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.field_11750;
import static net.minecraft.class_2558.class_2559.field_11745;

public class TeleportAnchorPagination extends BasePaginationMessage<TeleportAnchor> {

    private final IMarkableRegion region;

    public TeleportAnchorPagination(IMarkableRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getTpAnchors().getAnchors(), buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static class_5250 buildTeleportAnchorInfoHeader(IProtectedRegion region, class_5250 flagListLink) {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", flagListLink, buildRegionInfoLink(region)));
    }

    public static List<class_2561> buildTeleportAnchorEntries(IMarkableRegion region, List<TeleportAnchor> tpAnchors) {
        List<TeleportAnchor> alphabeticAnchors = tpAnchors.stream()
                .sorted(Comparator.comparing(TeleportAnchor::getName))
                .toList();
        return alphabeticAnchors.stream()
                .map(tpAnchor -> buildRemoveTeleportAnchorEntry(region, tpAnchor))
                .collect(Collectors.toList());
    }

    /**
     * Builds a TextComponent for teleport anchor management
     * [x] teleport-anchor-name @ [teleport link] | [show] [hide] [rename] [set]
     */
    public static class_2561 buildRemoveTeleportAnchorEntry(IMarkableRegion region, TeleportAnchor tpAnchor) {
        var teleportAnchorRemoveLink = buildRemoveTeleportAnchorLink(region, tpAnchor);
        var anchorNameText = class_2561.method_48322("cli.msg.info.region.tp-anchor.text", "%s", tpAnchor.getName());
        var anchorNameHover = class_2561.method_48322("cli.msg.info.region.tp-anchor.hover", "Anchor '%s' @ %s", tpAnchor.getName(), shortBlockPosBracketed(tpAnchor.getPos()));
        var anchorName = buildTextWithHoverMsg(anchorNameText, anchorNameHover, field_1060);

        var tpLink = buildTeleportToAnchorLink(region, tpAnchor);

        var showLink = buildShowTeleportAnchorLink(region, tpAnchor);
        var hideLink = buildHideTeleportAnchorLink(region, tpAnchor);
        var renameLink = buildRenameTeleportAnchorLink(region, tpAnchor);
        var updateLink = buildUpdateTeleportAnchorLink(region, tpAnchor);

        return Messages.substitutable(" - %s %s @ %s | %s %s %s %s",
                teleportAnchorRemoveLink, anchorName, tpLink, showLink, hideLink, updateLink, renameLink);
    }

    public static class_2561 buildShowTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        var cmd = buildShowTpAnchorCommand(region, tpAnchor.getName());
        var text = class_2561.method_48321("cli.msg.info.region.tp-anchor.show.link.text", "s");
        var hover = class_2561.method_48321("cli.msg.info.region.tp-anchor.show.link.hover", "Click to show teleport anchor");
        return buildExecuteCmdLinkWithBrackets(text, hover, cmd, field_11750, LINK_COLOR);
    }

    public static class_2561 buildHideTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        var cmd = buildHideTpAnchorCommand(region, tpAnchor.getName());
        var text = class_2561.method_48321("cli.msg.info.region.tp-anchor.hide.link.text", "h");
        var hover = class_2561.method_48321("cli.msg.info.region.tp-anchor.hide.link.hover", "Click to hide teleport anchor");
        return buildExecuteCmdLinkWithBrackets(text, hover, cmd, field_11750, LINK_COLOR);
    }

    public static class_2561 buildRemoveTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        var rmCmd = buildRemoveTeleportAnchorCommand(region, tpAnchor.getName());
        var hover = class_2561.method_48322("cli.msg.info.region.tp-anchor.remove.link.hover", "Click to remove '%s' from region %s", tpAnchor.getName(), region.getName());
        var text = class_2561.method_48321("cli.link.remove", "x");
        return buildExecuteCmdComponent(text, hover, rmCmd, field_11750, REMOVE_CMD_COLOR);
    }

    public static class_2561 buildTeleportToAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        var cmd = buildTeleportTpAnchorCommand(region, tpAnchor.getName());
        var text = class_2561.method_48322("cli.msg.info.region.tp-anchor.tp.link.text", "%s", commandBlockPosStr(tpAnchor.getPos()));
        var hover = class_2561.method_48322("cli.msg.info.region.tp-anchor.tp.link.hover", "Click to teleport to '%s' @ %s", tpAnchor.getName(), shortBlockPosBracketed(tpAnchor.getPos()));
        return buildExecuteCmdLinkWithBrackets(text, hover, cmd, field_11750, LINK_COLOR);
    }

    public static class_2561 buildRenameTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestRenameTpAnchorCommand(region, tpAnchor.getName());
        var hover = class_2561.method_48322("cli.msg.info.region.tp-anchor.rename.link.hover", "Click to rename '%s'", tpAnchor.getName());
        var text = class_2561.method_48321("cli.msg.info.region.tp-anchor.rename.link.text", "r");
        return buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, field_11745, LINK_COLOR);
    }

    public static class_2561 buildUpdateTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestUpdateTpAnchorCommand(region, tpAnchor.getName());
        var hover = class_2561.method_48321("cli.msg.info.region.tp-anchor.update.link.hover", "Click to set new teleport position");
        var text = class_2561.method_48321("cli.msg.info.region.tp-anchor.update.link.text", "p");
        return buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, field_11745, LINK_COLOR);
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322("cli.msg.info.region.tp-anchor.empty", "No teleport anchors defined in %s", buildRegionInfoLink(region));
    }

    @Override
    public class_2561 header() {
        return buildTeleportAnchorInfoHeader(this.region, buildRegionTeleportAnchorListLink(this.region));
    }

    @Override
    public List<class_2561> buildEntries() {
        return buildTeleportAnchorEntries(this.region, this.pageContent);
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", buildSuggestAddTeleportAnchorLink(region, "tpAnchor", class_2338.field_10980));
    }

    /**
     * [m] teleport anchor(s) [+]
     */
    public static class_5250 buildRegionTeleportAnchorListLink(IMarkableRegion region) {
        class_5250 numberHover = class_2561.method_48322("cli.msg.info.region.tp-anchor.link.hover", "%s teleport anchor(s) defined in %s", region.getTpAnchors().getAnchors().size(), region.getName());
        class_5250 regionTpAnchorAmountPlain = buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, LINK_COLOR);
        class_5250 regionTpAnchorAmount = buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, LINK_COLOR);
        class_5250 tpAnchorHoverText = class_2561.method_48322("cli.msg.info.region.tp-anchor.link.hover", "%s teleport anchor(s) defined in %s", region.getTpAnchors().getAnchors().size(), region.getName());
        String listAnchorCmd = buildListTeleportAnchorCommand(region);
        class_5250 tpAnchorListLink = buildExecuteCmdComponent(regionTpAnchorAmount, tpAnchorHoverText, listAnchorCmd, field_11750, LINK_COLOR);
        class_5250 tpAnchorComp = region.getTpAnchors().getAnchors().isEmpty() ? regionTpAnchorAmountPlain : tpAnchorListLink;
        return Messages.substitutable("%s %s",
                class_2561.method_48322("cli.msg.info.region.tp-anchor.link.text", "%s teleport anchor(s)", tpAnchorComp),
                buildSuggestAddTeleportAnchorLink(region, "tpAnchor-name", class_2338.field_10980));
    }

    public static class_5250 buildSuggestAddTeleportAnchorLink(IMarkableRegion region, String name, class_2338 pos) {
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.tp-anchor.add.link.hover", "Click to create new teleport anchor in %s", region.getName());
        class_5250 linkText = class_2561.method_48321("cli.link.add", "+");
        String cmd = buildAddTeleportAnchorCommand(region, name, pos);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11745, ADD_CMD_COLOR);
    }


}
