/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.config.server;

import de.z0rdak.yawp.api.FlagTagRegister;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagTag;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingConfig {
    public static final ModConfigSpec CONFIG_SPEC;
    public static final String CONFIG_NAME = "yawp-logging.toml";
    public static final Logger LOGGING_CONFIG_LOGGER;
    private static final ModConfigSpec.ConfigValue<Boolean> FLAG_CHECK_LOG;
    private static final ModConfigSpec.ConfigValue<Boolean> FLAG_RESULT_LOG;
    private static final ModConfigSpec.ConfigValue<Boolean> LOG_EMPTY_RESULTS;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> LOG_RESULT_VALUES;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> LOG_FLAG_TAGS;
    private static final ModConfigSpec.ConfigValue<List<? extends String>> LOG_FLAGS;

    public static Set<String> getFlagTags() {
        return ((List)LOG_FLAG_TAGS.get()).stream().filter(Objects::nonNull).map(String::toString).collect(Collectors.toSet());
    }

    public static Set<String> getFlagsToLog() {
        return ((List)LOG_FLAGS.get()).stream().filter(Objects::nonNull).map(String::toString).collect(Collectors.toSet());
    }

    public static Set<String> getResultValuesToLog() {
        return ((List)LOG_RESULT_VALUES.get()).stream().filter(Objects::nonNull).map(String::toString).collect(Collectors.toSet());
    }

    private static boolean isValidTag(Object entity) {
        if (entity instanceof String) {
            String str = (String)entity;
            try {
                if (str.equals("*")) {
                    return true;
                }
                FlagTag tag = FlagTagRegister.from(class_2960.method_12829((String)str));
                return tag != null;
            }
            catch (IllegalArgumentException e) {
                LOGGING_CONFIG_LOGGER.warn("Invalid flag category supplied for 'log_flag_categories': {}", entity);
                return false;
            }
        }
        return false;
    }

    public static boolean isValidFlag(Object flag) {
        if (flag instanceof String) {
            boolean contains = RegionFlag.contains((String)flag);
            if (!contains) {
                LOGGING_CONFIG_LOGGER.warn("Invalid flag supplied for 'log_flags': {}", flag);
            }
            return contains;
        }
        LOGGING_CONFIG_LOGGER.warn("Invalid flag supplied for 'log_flags': {}", flag);
        return false;
    }

    public static boolean isValidFlagState(Object flagState) {
        if (flagState instanceof String) {
            boolean contains = FlagState.validLoggingStates((String)flagState);
            if (!contains) {
                LOGGING_CONFIG_LOGGER.warn("Invalid FlagState supplied for 'log_result_values': {}", flagState);
            }
            return contains;
        }
        LOGGING_CONFIG_LOGGER.warn("Invalid FlagState supplied for 'log_result_values': {}", flagState);
        return false;
    }

    public static boolean shouldLogFlagChecks() {
        return (Boolean)FLAG_CHECK_LOG.get();
    }

    public static boolean shouldLogFlagCheckResults() {
        return (Boolean)FLAG_RESULT_LOG.get();
    }

    public static boolean shouldLogEmptyResults() {
        return (Boolean)LOG_EMPTY_RESULTS.get();
    }

    public static boolean logCheck(FlagCheckEvent check) {
        boolean matchesFlagOrCategory;
        boolean bl = matchesFlagOrCategory = LoggingConfig.flagMatchesCategory(check) || LoggingConfig.matchesFlag(check);
        if (matchesFlagOrCategory) {
            LOGGING_CONFIG_LOGGER.info("[Check] {}, at {}, in '{}', Player={}, Id={}", (Object)check.getRegionFlag().name, (Object)AreaUtil.blockPosStr(check.getTarget()), (Object)check.getDimension().method_29177().toString(), (Object)(check.getPlayer() == null ? "n/a" : check.getPlayer().method_5476().getString()), (Object)check.getId());
        }
        return true;
    }

    public static FlagCheckResult logResult(FlagCheckResult result) {
        boolean matchesFlagOrCategory;
        FlagCheckEvent check = result.getFlagCheck();
        boolean bl = matchesFlagOrCategory = LoggingConfig.flagMatchesCategory(check) || LoggingConfig.matchesFlag(check);
        if (matchesFlagOrCategory && LoggingConfig.matchesResult(result)) {
            if (result.getResponsible() == null || result.getFlag() == null) {
                if (LoggingConfig.shouldLogEmptyResults()) {
                    LOGGING_CONFIG_LOGGER.info("[Result] No region for check with Id={}", (Object)check.getId());
                }
            } else if (result.getResponsible().getRegionType() != RegionType.LOCAL) {
                IFlag flag = result.getFlag();
                LOGGING_CONFIG_LOGGER.info("[Result] {} ({}), Region='{}', Id={}", (Object)flag.getName(), (Object)result.getFlagState().name, (Object)result.getResponsible().getName(), (Object)result.getFlagCheck().getId());
            } else {
                IFlag flag = result.getFlag();
                LOGGING_CONFIG_LOGGER.info("[Result] {} ({}), Region='{}', in '{}', Id={}", (Object)flag.getName(), (Object)result.getFlagState().name, (Object)result.getResponsible().getName(), (Object)result.getResponsible().getDim().method_29177().toString(), (Object)result.getFlagCheck().getId());
            }
        }
        return result;
    }

    public static boolean matchesResult(FlagCheckResult result) {
        return LoggingConfig.getResultValuesToLog().contains(result.getFlagState().name);
    }

    public static boolean flagMatchesCategory(FlagCheckEvent check) {
        return RegionFlag.matchesCategory(check.getRegionFlag(), LoggingConfig.getFlagTags());
    }

    public static boolean matchesFlag(FlagCheckEvent check) {
        return LoggingConfig.getFlagsToLog().contains(check.getRegionFlag().name);
    }

    static {
        LOGGING_CONFIG_LOGGER = LogManager.getLogger((String)("yawp".toUpperCase() + "-Logging-Config"));
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        BUILDER.push("YetAnotherWorldProtector logging configuration").build();
        FLAG_CHECK_LOG = BUILDER.comment("Enable logging of flag checks.").define("log_flag_check", false);
        FLAG_RESULT_LOG = BUILDER.comment("Enable logging of flag check results.").define("log_flag_result", false);
        LOG_EMPTY_RESULTS = BUILDER.comment("Enable logging of empty (without responsible region) flag check results.").define("log_empty_results", false);
        LOG_RESULT_VALUES = BUILDER.comment("List of flags result states which shall be logged. By default only denied results will be logged.\n Valid FlagStates are: allowed and denied").defineListAllowEmpty(List.of("log_result_values"), () -> Collections.singletonList(FlagState.DENIED.name), null, LoggingConfig::isValidFlagState);
        LOG_FLAG_TAGS = BUILDER.comment("List of flag tags which shall be logged.\nValid tags are: player, beneficial, block, entity, item, environment, protection, high-frequency and * (for all).").defineListAllowEmpty(List.of("log_flag_tags"), () -> Collections.singletonList(FlagTagRegister.PLAYER.tagRl().toString()), null, LoggingConfig::isValidTag);
        LOG_FLAGS = BUILDER.comment("List of flags which shall be logged.").defineListAllowEmpty(List.of("log_flags"), () -> Arrays.asList(RegionFlag.BREAK_BLOCKS.name, RegionFlag.PLACE_BLOCKS.name), null, LoggingConfig::isValidFlag);
        BUILDER.pop();
        CONFIG_SPEC = BUILDER.build();
    }
}

