/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;

public class RegionAnchors {
    protected Map<String, TeleportAnchor> tpAnchors;

    public RegionAnchors() {
        this.tpAnchors = new HashMap<String, TeleportAnchor>();
    }

    public RegionAnchors(Map<String, TeleportAnchor> tpAnchors) {
        this.tpAnchors = tpAnchors;
    }

    public Map<String, TeleportAnchor> getTpAnchors() {
        return this.tpAnchors;
    }

    public void setTpAnchors(Map<String, TeleportAnchor> tpAnchors) {
        this.tpAnchors = tpAnchors;
    }

    public TeleportAnchor addTpAnchor(class_2338 pos) {
        String derivedName = ChatComponentBuilder.tinyBlockPos(pos);
        return this.addTpAnchor(pos, derivedName);
    }

    public boolean hasAnchor(String name) {
        return this.tpAnchors.containsKey(name);
    }

    public TeleportAnchor addTpAnchor(class_2338 pos, String name) {
        TeleportAnchor anchor = new TeleportAnchor(pos, name);
        this.tpAnchors.put(name, anchor);
        return anchor;
    }

    public void removeTpAnchor(String name) {
        this.tpAnchors.remove(name);
    }

    public void rename(String name, String newName) {
        TeleportAnchor teleportAnchor = this.tpAnchors.get(name);
        this.tpAnchors.remove(name);
        teleportAnchor.setName(newName);
        this.tpAnchors.put(newName, teleportAnchor);
    }

    public void addOrUpdate(String name, class_2338 pos) {
        if (this.tpAnchors.containsKey(name)) {
            TeleportAnchor teleportAnchor = this.tpAnchors.get(name);
            teleportAnchor.setPos(pos);
            return;
        }
        this.addTpAnchor(pos, name);
    }

    public void removeTpAnchor(class_2338 pos) {
        this.tpAnchors.remove(ChatComponentBuilder.tinyBlockPos(pos));
    }

    public TeleportAnchor getTpAnchor(String name) {
        return this.tpAnchors.get(name);
    }

    public List<TeleportAnchor> getAnchors() {
        return new ArrayList<TeleportAnchor>(this.tpAnchors.values());
    }
}

