/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1915;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @Inject(method={"startRiding(Lnet/minecraft/world/entity/Entity;Z)Z"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void spawnChildFromBreeding(class_1297 vehicle, boolean force, CallbackInfoReturnable<Boolean> cir) {
        class_1297 rider = (class_1297)this;
        if (HandlerUtil.isServerSide(rider) && rider instanceof class_1657) {
            class_1657 player = (class_1657)rider;
            FlagCheckEvent checkEvent = new FlagCheckEvent(vehicle.method_24515(), RegionFlag.ANIMAL_MOUNTING, HandlerUtil.getDimKey(vehicle), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                cir.setReturnValue((Object)false);
            });
        }
    }

    @Inject(method={"thunderHit"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onHitByLightning(class_3218 world, class_1538 lightning, CallbackInfo ci) {
        class_1297 poorSoul = (class_1297)this;
        if (HandlerUtil.isServerSide(poorSoul)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(poorSoul.method_24515(), RegionFlag.LIGHTNING_PROT, HandlerUtil.getDimKey(poorSoul), null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    @Inject(method={"stopRiding"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void spawnChildFromBreeding(CallbackInfo ci) {
        class_1297 rider = (class_1297)this;
        if (HandlerUtil.isServerSide(rider) && rider instanceof class_1657) {
            class_1657 player = (class_1657)rider;
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.ANIMAL_UNMOUNTING, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }

    @Inject(method={"teleportCrossDimension"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onChangeDimension(class_3218 level, class_5454 teleportTransition, CallbackInfoReturnable<class_1297> cir) {
        class_1297 self = (class_1297)this;
        if (HandlerUtil.isServerSide(self.method_37908())) {
            RegionDataManager.initLevelDataOnChangeWorld(null, self.method_37908(), (class_1937)teleportTransition.comp_2820());
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL, HandlerUtil.getDimKey(self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            if (self instanceof class_1657) {
                class_1657 player = (class_1657)self;
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_PLAYERS, HandlerUtil.getDimKey(self), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    cir.setReturnValue(null);
                });
            }
            if (self instanceof class_1542) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_ITEMS, HandlerUtil.getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            }
            if (HandlerUtil.isAnimal(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_ANIMALS, HandlerUtil.getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            }
            if (HandlerUtil.isMonster(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_MONSTERS, HandlerUtil.getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            }
            if (self instanceof class_1915) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_VILLAGERS, HandlerUtil.getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            }
            if (self instanceof class_1688) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_PORTAL_MINECARTS, HandlerUtil.getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(null));
            }
        }
    }
}

