/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api;

import de.z0rdak.yawp.api.Flag;
import de.z0rdak.yawp.core.flag.FlagFrequency;
import de.z0rdak.yawp.core.flag.FlagMetaInfo;
import de.z0rdak.yawp.core.flag.FlagTag;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagRegister {
    private static final Map<ResourceLocation, Flag> flagRegister = new HashMap<ResourceLocation, Flag>();
    public static final Flag PLAYER_BREED_ANIMAL = new Flag(FlagRegister.flagId("player/breed_animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENTITY, FlagTag.PLAYER), FlagFrequency.LOW));
    public static final Flag PLAYER_MOUNT = new Flag(FlagRegister.flagId("player/mount"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENTITY, FlagTag.PLAYER), FlagFrequency.NEGLIGIBLE));
    public static final Flag PLAYER_TAME_ANIMAL = new Flag(FlagRegister.flagId("player/tame_animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENTITY, FlagTag.PLAYER), FlagFrequency.NEGLIGIBLE));
    public static final Flag PLAYER_UNMOUNTING = new Flag(FlagRegister.flagId("player/unmount"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENTITY, FlagTag.PLAYER), FlagFrequency.NEGLIGIBLE));
    public static final Flag PLAYER_STRIP_WOOD = new Flag(FlagRegister.flagId("player/strip_wood"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_BREAK_BLOCKS = new Flag(FlagRegister.flagId("player/break_blocks"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_USE_CONTAINER = new Flag(FlagRegister.flagId("player/use_container"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_GAIN_LOOT = new Flag(FlagRegister.flagId("player/gain_loot"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.LOW));
    public static final Flag PLAYER_USE_CHEST_ACCESS = new Flag(FlagRegister.flagId("player/use_enderchest"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_ENTER_LEVEL = new Flag(FlagRegister.flagId("player/enter_level"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.LOW));
    public static final Flag PLAYER_USE_COMMANDS = new Flag(FlagRegister.flagId("player/use_commands"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.LOW));
    public static final Flag PLAYER_TILL = new Flag(FlagRegister.flagId("player/till_farmland"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_IGNITE_EXPLOSIVES = new Flag(FlagRegister.flagId("player/ignite_explosives"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.PLAYER), FlagFrequency.LOW));
    public static final Flag PLAYER_HURT = new Flag(FlagRegister.flagId("player/hurt"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION), FlagFrequency.NORMAL));
    public static final Flag PLAYER_DROP_ITEM = new Flag(FlagRegister.flagId("player/drop_item"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_PICKUP_ITEM = new Flag(FlagRegister.flagId("player/item_pickup"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_APPLY_KNOCKBACK = new Flag(FlagRegister.flagId("player/apply_knockback"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_KNOCKBACK = new Flag(FlagRegister.flagId("player/knockback"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_GAIN_LEVEL = new Flag(FlagRegister.flagId("player/gain_level"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_WALKER_FREEZE = new Flag(FlagRegister.flagId("player/walker_freeze"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_FALL_DAMAGE = new Flag(FlagRegister.flagId("player/fall_damage"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_FIRE_BOW = new Flag(FlagRegister.flagId("player/fire_bow"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_MELEE_ANIMALS = new Flag(FlagRegister.flagId("player/melee_animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_MELEE_MONSTERS = new Flag(FlagRegister.flagId("player/melee_monsters"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_MELEE_PLAYERS = new Flag(FlagRegister.flagId("player/melee_players"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_MELEE_VILLAGERS = new Flag(FlagRegister.flagId("player/melee_villagers"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_MELEE_WANDERING_TRADER = new Flag(FlagRegister.flagId("player/melee_wtrader"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NEGLIGIBLE));
    public static final Flag PLAYER_FLIGHT = new Flag(FlagRegister.flagId("player/flight"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_PVP = new Flag(FlagRegister.flagId("player/pvp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_EDIT_SIGNS = new Flag(FlagRegister.flagId("player/edit_signs"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_PLACE_BLOCKS = new Flag(FlagRegister.flagId("player/place_blocks"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_PLACE_FLUIDS = new Flag(FlagRegister.flagId("player/place_fluids"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_SCOOP_FLUIDS = new Flag(FlagRegister.flagId("player/scoop_fluids"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_CHAT = new Flag(FlagRegister.flagId("player/chat"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_SET_SPAWN = new Flag(FlagRegister.flagId("player/set_spawn"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_SHOVEL_PATH = new Flag(FlagRegister.flagId("player/shovel_path"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_CREATE_PORTAL = new Flag(FlagRegister.flagId("player/create_portal"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_TOOL_SECONDARY = new Flag(FlagRegister.flagId("player/tools_secondary"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ITEM), FlagFrequency.NORMAL));
    public static final Flag PLAYER_TRAMPLE_FARMLAND = new Flag(FlagRegister.flagId("player/trample_farmland"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_USE_BLOCKS = new Flag(FlagRegister.flagId("player/use_blocks"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_USE_BONEMEAL = new Flag(FlagRegister.flagId("player/use_bonemeal"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag PLAYER_USE_ELYTRA = new Flag(FlagRegister.flagId("player/use_elytra"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_USE_ENDERPEARL = new Flag(FlagRegister.flagId("player/use_enderpearl"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_ENDERPEARL_AWAY = new Flag(FlagRegister.flagId("player/enderpearl_away"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_INTERACT = new Flag(FlagRegister.flagId("player/interact"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag PLAYER_USE_ITEMS = new Flag(FlagRegister.flagId("player/use_items"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.ITEM), FlagFrequency.NORMAL));
    public static final Flag PLAYER_SLEEP = new Flag(FlagRegister.flagId("player/sleep"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag PLAYER_ENTER_PORTAL = new Flag(FlagRegister.flagId("player/enter_portal"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_KEEP_XP = new Flag(FlagRegister.flagId("player/keep_xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_KEEP_INV = new Flag(FlagRegister.flagId("player/keep_inv"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_APPLY_HUNGER = new Flag(FlagRegister.flagId("player/apply_hunger"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION, FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_DROP_XP = new Flag(FlagRegister.flagId("player/drop_xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag PLAYER_GAIN_XP = new Flag(FlagRegister.flagId("player/gain_xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag PLAYER_PICKUP_XP = new Flag(FlagRegister.flagId("player/pickup_xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PLAYER), FlagFrequency.NORMAL));
    public static final Flag DRAGON_BLOCK_PROT = new Flag(FlagRegister.flagId("env/dragon_destruction"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag DROP_LOOT_ALL = new Flag(FlagRegister.flagId("entity/drop_loot"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag ENDERMAN_GRIEFING = new Flag(FlagRegister.flagId("griefing/enderman"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.LOW));
    public static final Flag ENDERMAN_TELEPORT = new Flag(FlagRegister.flagId("mob/enderman_tp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.LOW));
    public static final Flag EXPLOSION_BLOCK = new Flag(FlagRegister.flagId("explosion/blocks"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag EXPLOSION_ENTITY = new Flag(FlagRegister.flagId("explosion/entities"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag EXPLOSION_CREEPER_BLOCK = new Flag(FlagRegister.flagId("griefing/creeper_explosion_blocks"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag EXPLOSION_CREEPER_ENTITY = new Flag(FlagRegister.flagId("griefing/creeper_explosion_entities"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag TRAMPLE_FARMLAND = new Flag(FlagRegister.flagId("griefing/trample_farmland"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.BLOCK), FlagFrequency.LOW));
    public static final Flag FALL_DAMAGE = new Flag(FlagRegister.flagId("entity/fall_damage"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION), FlagFrequency.NORMAL));
    public static final Flag FALL_DAMAGE_ANIMALS = new Flag(FlagRegister.flagId("entity/fall_damage_animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION), FlagFrequency.LOW));
    public static final Flag FALL_DAMAGE_MONSTERS = new Flag(FlagRegister.flagId("entity/fall_damage_monsters"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION), FlagFrequency.LOW));
    public static final Flag SHULKER_TELEPORT = new Flag(FlagRegister.flagId("entity/shulker_tp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENTITY), FlagFrequency.LOW));
    public static final Flag FALL_DAMAGE_VILLAGERS = new Flag(FlagRegister.flagId("entity/fall_damage_villagers"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.PROTECTION), FlagFrequency.NEGLIGIBLE));
    public static final Flag LAVA_FLOW = new Flag(FlagRegister.flagId("env/lava_flow"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.HIGH_FREQUENCY, FlagTag.ENVIRONMENT), FlagFrequency.VERY_HIGH));
    public static final Flag LIGHTNING_PROT = new Flag(FlagRegister.flagId("env/lightning"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag FLUID_FLOW = new Flag(FlagRegister.flagId("env/fluid_flow"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.HIGH_FREQUENCY, FlagTag.ENVIRONMENT), FlagFrequency.VERY_HIGH));
    public static final Flag LEAF_DECAY = new Flag(FlagRegister.flagId("env/leaf_decay"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag FIRE_TICK = new Flag(FlagRegister.flagId("env/fire_tick"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag NO_ITEM_DESPAWN = new Flag(FlagRegister.flagId("item/despawn"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ITEM, FlagTag.PROTECTION), FlagFrequency.NORMAL));
    public static final Flag MOB_GRIEFING = new Flag(FlagRegister.flagId("mob/griefing"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag SNOW_FALL = new Flag(FlagRegister.flagId("env/snow_fall"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag SNOW_MELTING = new Flag(FlagRegister.flagId("env/snow_melting"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.BLOCK, FlagTag.ENVIRONMENT), FlagFrequency.TICK));
    public static final Flag SPAWNING_ALL = new Flag(FlagRegister.flagId("spawning/all"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.TICK));
    public static final Flag SPAWNING_ANIMAL = new Flag(FlagRegister.flagId("spawning/animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag SPAWNING_GOLEM = new Flag(FlagRegister.flagId("spawning/golems"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.LOW));
    public static final Flag SPAWNING_MONSTER = new Flag(FlagRegister.flagId("spawning/monsters"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag SPAWNING_SLIME = new Flag(FlagRegister.flagId("spawning/slimes"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag SPAWNING_TRADER = new Flag(FlagRegister.flagId("spawning/traders"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.LOW));
    public static final Flag SPAWNING_VILLAGER = new Flag(FlagRegister.flagId("spawning/villagers"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.LOW));
    public static final Flag SPAWNING_XP = new Flag(FlagRegister.flagId("spawning/xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL = new Flag(FlagRegister.flagId("env/enter_portal"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL_ANIMALS = new Flag(FlagRegister.flagId("env/enter_portal_animals"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL_ITEMS = new Flag(FlagRegister.flagId("env/enter_portal_items"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL_MINECARTS = new Flag(FlagRegister.flagId("env/enter_portal_minecarts"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL_MONSTERS = new Flag(FlagRegister.flagId("env/enter_portal_monsters"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag USE_PORTAL_VILLAGERS = new Flag(FlagRegister.flagId("env/enter_portal_villagers"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.NORMAL));
    public static final Flag WATER_FLOW = new Flag(FlagRegister.flagId("env/water_flow"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.HIGH_FREQUENCY, FlagTag.ENVIRONMENT), FlagFrequency.VERY_HIGH));
    public static final Flag WITHER_BLOCK_PROT = new Flag(FlagRegister.flagId("griefing/wither_destruction"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.BLOCK), FlagFrequency.NORMAL));
    public static final Flag XP_DROP_ALL = new Flag(FlagRegister.flagId("env/drop_xp"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag XP_DROP_MONSTER = new Flag(FlagRegister.flagId("entity/drop_xp_monsters"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(), FlagFrequency.NORMAL));
    public static final Flag ZOMBIE_DOOR_PROT = new Flag(FlagRegister.flagId("griefing/break_doors"), new FlagMetaInfo(FlagType.BOOLEAN_FLAG, Set.of(FlagTag.ENVIRONMENT, FlagTag.ENTITY), FlagFrequency.LOW));

    private FlagRegister() {
    }

    private static ResourceLocation flagId(String flagName) {
        return ResourceLocation.fromNamespaceAndPath((String)"yawp", (String)flagName);
    }

    public static boolean isSame(String flagId, Flag flag) {
        ResourceLocation left = ResourceLocation.tryParse((String)flagId);
        return left != null && left.equals((Object)flag.id());
    }

    public static boolean isSame(Flag left, Flag right) {
        return FlagRegister.isSame(left.id(), right);
    }

    public static boolean isSame(ResourceLocation flagId, Flag flag) {
        return flagId.equals((Object)flag.id());
    }

    private static boolean registerFlag(Flag flag) {
        if (FlagRegister.isFlagRegistered(flag.id())) {
            return false;
        }
        flagRegister.put(flag.id(), flag);
        return true;
    }

    public static boolean registerFlag(@NotNull ResourceLocation flagRl, @NotNull FlagMetaInfo flagMetaInfo) {
        if (flagRl.getNamespace().equalsIgnoreCase("yawp")) {
            throw new IllegalArgumentException("You are not permitted to register flags with the YAWP namespace!");
        }
        return FlagRegister.registerFlag(new Flag(flagRl, flagMetaInfo));
    }

    public static boolean registerFlag(@NotNull String modId, @NotNull String flagId, @NotNull FlagMetaInfo flagMetaInfo) {
        ResourceLocation rl = ResourceLocation.tryBuild((String)modId, (String)flagId);
        if (rl == null) {
            return false;
        }
        return FlagRegister.registerFlag(rl, flagMetaInfo);
    }

    public static Set<Flag> getFlagsByFrequency(FlagFrequency frequency) {
        return flagRegister.values().stream().filter(flag -> flag.flagInfo().frequency() == frequency).collect(Collectors.toSet());
    }

    public static boolean isFlagRegistered(ResourceLocation rl) {
        return flagRegister.containsKey(rl);
    }

    public static boolean isRegistered(String flagIdentifier) {
        try {
            ResourceLocation rl = ResourceLocation.tryParse((String)flagIdentifier);
            if (rl == null) {
                return false;
            }
            return FlagRegister.isFlagRegistered(rl);
        }
        catch (ResourceLocationException rle) {
            return false;
        }
    }

    public static Flag byId(String flagIdentifier) throws IllegalArgumentException {
        if (FlagRegister.isRegistered(flagIdentifier)) {
            ResourceLocation rl = ResourceLocation.tryParse((String)flagIdentifier);
            if (rl == null) {
                throw new IllegalArgumentException("Invalid region flag identifier supplied");
            }
            return flagRegister.get(rl);
        }
        throw new IllegalArgumentException("Invalid region flag identifier supplied");
    }

    public static Optional<Flag> getFlagOptional(ResourceLocation rl) {
        return FlagRegister.isFlagRegistered(rl) ? Optional.of(flagRegister.get(rl)) : Optional.empty();
    }

    @Nullable
    public static Flag getFlag(ResourceLocation rl) {
        return FlagRegister.isFlagRegistered(rl) ? flagRegister.get(rl) : null;
    }

    public static List<String> getFlagNames() {
        return flagRegister.keySet().stream().map(ResourceLocation::toString).collect(Collectors.toList());
    }

    public static Set<Flag> getFlags() {
        return new HashSet<Flag>(flagRegister.values());
    }

    public static Set<Flag> getFlagsMatchingCategory(FlagTag tag) {
        return FlagRegister.getFlags().stream().filter(flag -> flag.flagInfo().tags().contains((Object)tag)).collect(Collectors.toSet());
    }

    public static boolean hasPlayerTag(IFlag flag) {
        Set<Flag> flagsMatchingCategory = FlagRegister.getFlagsMatchingCategory(FlagTag.PLAYER);
        Flag regionFlag = FlagRegister.byId(flag.getName());
        return flagsMatchingCategory.contains(regionFlag);
    }

    public static boolean hasPlayerTag(Flag flag) {
        return flag.flagInfo().tags().contains((Object)FlagTag.PLAYER);
    }

    public static boolean matchesCategory(Flag flag, Set<String> tags) {
        Set flagTags = flag.flagInfo().tags().stream().map(c -> c.name).collect(Collectors.toSet());
        return tags.stream().anyMatch(flagTags::contains);
    }

    static {
        FlagRegister.registerFlag(PLAYER_BREED_ANIMAL);
        FlagRegister.registerFlag(PLAYER_MOUNT);
        FlagRegister.registerFlag(PLAYER_TAME_ANIMAL);
        FlagRegister.registerFlag(PLAYER_UNMOUNTING);
        FlagRegister.registerFlag(PLAYER_STRIP_WOOD);
        FlagRegister.registerFlag(PLAYER_BREAK_BLOCKS);
        FlagRegister.registerFlag(PLAYER_USE_CONTAINER);
        FlagRegister.registerFlag(PLAYER_GAIN_LOOT);
        FlagRegister.registerFlag(PLAYER_USE_CHEST_ACCESS);
        FlagRegister.registerFlag(PLAYER_ENTER_LEVEL);
        FlagRegister.registerFlag(PLAYER_USE_COMMANDS);
        FlagRegister.registerFlag(PLAYER_TILL);
        FlagRegister.registerFlag(PLAYER_IGNITE_EXPLOSIVES);
        FlagRegister.registerFlag(PLAYER_HURT);
        FlagRegister.registerFlag(PLAYER_DROP_ITEM);
        FlagRegister.registerFlag(PLAYER_PICKUP_ITEM);
        FlagRegister.registerFlag(PLAYER_APPLY_KNOCKBACK);
        FlagRegister.registerFlag(PLAYER_KNOCKBACK);
        FlagRegister.registerFlag(PLAYER_GAIN_LEVEL);
        FlagRegister.registerFlag(PLAYER_WALKER_FREEZE);
        FlagRegister.registerFlag(PLAYER_FALL_DAMAGE);
        FlagRegister.registerFlag(PLAYER_FIRE_BOW);
        FlagRegister.registerFlag(PLAYER_MELEE_ANIMALS);
        FlagRegister.registerFlag(PLAYER_MELEE_MONSTERS);
        FlagRegister.registerFlag(PLAYER_MELEE_PLAYERS);
        FlagRegister.registerFlag(PLAYER_MELEE_VILLAGERS);
        FlagRegister.registerFlag(PLAYER_MELEE_WANDERING_TRADER);
        FlagRegister.registerFlag(PLAYER_FLIGHT);
        FlagRegister.registerFlag(PLAYER_PVP);
        FlagRegister.registerFlag(PLAYER_EDIT_SIGNS);
        FlagRegister.registerFlag(PLAYER_PLACE_BLOCKS);
        FlagRegister.registerFlag(PLAYER_PLACE_FLUIDS);
        FlagRegister.registerFlag(PLAYER_SCOOP_FLUIDS);
        FlagRegister.registerFlag(PLAYER_CHAT);
        FlagRegister.registerFlag(PLAYER_SET_SPAWN);
        FlagRegister.registerFlag(PLAYER_SHOVEL_PATH);
        FlagRegister.registerFlag(PLAYER_CREATE_PORTAL);
        FlagRegister.registerFlag(PLAYER_TOOL_SECONDARY);
        FlagRegister.registerFlag(PLAYER_TRAMPLE_FARMLAND);
        FlagRegister.registerFlag(PLAYER_USE_BLOCKS);
        FlagRegister.registerFlag(PLAYER_USE_BONEMEAL);
        FlagRegister.registerFlag(PLAYER_USE_ELYTRA);
        FlagRegister.registerFlag(PLAYER_USE_ENDERPEARL);
        FlagRegister.registerFlag(PLAYER_ENDERPEARL_AWAY);
        FlagRegister.registerFlag(PLAYER_INTERACT);
        FlagRegister.registerFlag(PLAYER_USE_ITEMS);
        FlagRegister.registerFlag(PLAYER_SLEEP);
        FlagRegister.registerFlag(PLAYER_ENTER_PORTAL);
        FlagRegister.registerFlag(PLAYER_KEEP_XP);
        FlagRegister.registerFlag(PLAYER_KEEP_INV);
        FlagRegister.registerFlag(PLAYER_APPLY_HUNGER);
        FlagRegister.registerFlag(PLAYER_DROP_XP);
        FlagRegister.registerFlag(PLAYER_GAIN_XP);
        FlagRegister.registerFlag(PLAYER_PICKUP_XP);
        FlagRegister.registerFlag(DRAGON_BLOCK_PROT);
        FlagRegister.registerFlag(DROP_LOOT_ALL);
        FlagRegister.registerFlag(ENDERMAN_GRIEFING);
        FlagRegister.registerFlag(ENDERMAN_TELEPORT);
        FlagRegister.registerFlag(EXPLOSION_BLOCK);
        FlagRegister.registerFlag(EXPLOSION_CREEPER_BLOCK);
        FlagRegister.registerFlag(EXPLOSION_CREEPER_ENTITY);
        FlagRegister.registerFlag(EXPLOSION_ENTITY);
        FlagRegister.registerFlag(FALL_DAMAGE);
        FlagRegister.registerFlag(FALL_DAMAGE_ANIMALS);
        FlagRegister.registerFlag(FALL_DAMAGE_MONSTERS);
        FlagRegister.registerFlag(FALL_DAMAGE_VILLAGERS);
        FlagRegister.registerFlag(FLUID_FLOW);
        FlagRegister.registerFlag(LAVA_FLOW);
        FlagRegister.registerFlag(LIGHTNING_PROT);
        FlagRegister.registerFlag(LEAF_DECAY);
        FlagRegister.registerFlag(FIRE_TICK);
        FlagRegister.registerFlag(MOB_GRIEFING);
        FlagRegister.registerFlag(NO_ITEM_DESPAWN);
        FlagRegister.registerFlag(SHULKER_TELEPORT);
        FlagRegister.registerFlag(SNOW_FALL);
        FlagRegister.registerFlag(SNOW_MELTING);
        FlagRegister.registerFlag(SPAWNING_ALL);
        FlagRegister.registerFlag(SPAWNING_ANIMAL);
        FlagRegister.registerFlag(SPAWNING_GOLEM);
        FlagRegister.registerFlag(SPAWNING_MONSTER);
        FlagRegister.registerFlag(SPAWNING_SLIME);
        FlagRegister.registerFlag(SPAWNING_TRADER);
        FlagRegister.registerFlag(SPAWNING_VILLAGER);
        FlagRegister.registerFlag(SPAWNING_XP);
        FlagRegister.registerFlag(TRAMPLE_FARMLAND);
        FlagRegister.registerFlag(USE_PORTAL);
        FlagRegister.registerFlag(USE_PORTAL_ANIMALS);
        FlagRegister.registerFlag(USE_PORTAL_ITEMS);
        FlagRegister.registerFlag(USE_PORTAL_MINECARTS);
        FlagRegister.registerFlag(USE_PORTAL_MONSTERS);
        FlagRegister.registerFlag(USE_PORTAL_VILLAGERS);
        FlagRegister.registerFlag(WATER_FLOW);
        FlagRegister.registerFlag(WITHER_BLOCK_PROT);
        FlagRegister.registerFlag(XP_DROP_ALL);
        FlagRegister.registerFlag(XP_DROP_MONSTER);
        FlagRegister.registerFlag(ZOMBIE_DOOR_PROT);
    }
}

