/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Unique
    @Nullable
    protected class_1657 attackingPlayer;

    @Inject(method={"knockback"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onKnockback(double strength, double x, double z, CallbackInfo ci) {
        class_1309 target = (class_1309)this;
        if (HandlerUtil.isServerSide((class_1297)target) && target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.KNOCKBACK_PLAYERS, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
            checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.INVINCIBLE, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    @Inject(method={"dropAllDeathLoot"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onDrop(class_3218 level, class_1282 source, CallbackInfo ci) {
        class_1309 target = (class_1309)this;
        if (HandlerUtil.isServerSide((class_1297)target)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.DROP_LOOT_ALL, HandlerUtil.getDimKey((class_1297)target));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                checkEvent = new FlagCheckEvent(target.method_24515(), RegionFlag.DROP_LOOT_PLAYER, HandlerUtil.getDimKey((class_1297)target), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    ci.cancel();
                });
            }
        }
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onFallDamage(double fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309)this;
        if (HandlerUtil.isServerSide((class_1297)self)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.FALL_DAMAGE, HandlerUtil.getDimKey((class_1297)self), self instanceof class_1657 ? (class_1657)self : null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
            if (HandlerUtil.isMonster((class_1297)self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.FALL_DAMAGE_MONSTERS, HandlerUtil.getDimKey((class_1297)self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
            }
            if (HandlerUtil.isAnimal((class_1297)self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.FALL_DAMAGE_ANIMALS, HandlerUtil.getDimKey((class_1297)self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
            }
            if (HandlerUtil.isVillager((class_1297)self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.FALL_DAMAGE_VILLAGERS, HandlerUtil.getDimKey((class_1297)self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue((Object)false));
            }
            if (self instanceof class_1657) {
                class_1657 player = (class_1657)self;
                checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.FALL_DAMAGE_PLAYERS, HandlerUtil.getDimKey((class_1297)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    cir.setReturnValue((Object)false);
                });
            }
        }
    }

    @Inject(method={"dropExperience"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V")}, cancellable=true, allow=1)
    public void onXpDrop(CallbackInfo ci) {
        FlagCheckEvent checkEvent;
        class_1309 self = (class_1309)this;
        if (this.attackingPlayer != null) {
            checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.XP_DROP_ALL, HandlerUtil.getDimKey((class_1297)self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
            checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.XP_DROP_PLAYER, HandlerUtil.getDimKey((class_1297)self), this.attackingPlayer);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                ci.cancel();
            });
            if (HandlerUtil.isMonster((class_1297)self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.XP_DROP_MONSTER, HandlerUtil.getDimKey((class_1297)self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    ci.cancel();
                });
            } else {
                checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.XP_DROP_OTHER, HandlerUtil.getDimKey((class_1297)self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    MessageSender.sendFlagMsg(deny);
                    ci.cancel();
                });
            }
        }
        if (self instanceof class_1657) {
            checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.KEEP_XP, HandlerUtil.getDimKey((class_1297)self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    @Inject(method={"createWitherRose"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")}, cancellable=true, allow=1)
    public void onCreateWitherRose(@Nullable class_1309 adversary, CallbackInfo ci, class_3218 level, boolean bl, class_2338 pos, class_2680 blockState) {
        class_1309 self = (class_1309)this;
        class_1937 world = self.method_37908();
        if (HandlerUtil.isServerSide(world)) {
            class_3218 serverLevel = (class_3218)self.method_37908();
            if (adversary instanceof class_1528) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.MOB_GRIEFING, (class_5321<class_1937>)serverLevel.method_27983(), null);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    ci.cancel();
                    class_1542 itemEntity = new class_1542((class_1937)serverLevel, self.method_23317(), self.method_23318(), self.method_23321(), new class_1799((class_1935)class_1802.field_17515));
                    serverLevel.method_8649((class_1297)itemEntity);
                });
            }
        }
    }
}

