/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.PaginationControl;
import de.z0rdak.yawp.util.text.messages.pagination.PaginationMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class BasePaginationMessage<T>
implements PaginationMessage<T> {
    public static int FIRST_PAGE_IDX = 0;
    protected final PaginationControl control;
    protected List<T> pageContent;
    protected List<class_2561> paginationLines = new ArrayList<class_2561>();

    protected BasePaginationMessage(List<T> entries, String cmd, int pageNumber, int pageSize) throws InvalidPageNumberException {
        int numberOfPages = entries.size() / pageSize;
        if (numberOfPages == 0 || entries.size() % pageSize != 0) {
            ++numberOfPages;
        }
        this.control = new PaginationControl(cmd, pageNumber, pageSize, numberOfPages);
        this.pageContent = PaginationMessage.getPageContentFor(entries, pageNumber, pageSize);
        if (this.control.pageNumber() < FIRST_PAGE_IDX || this.control.pageNumber() >= this.control.numberOfPages()) {
            class_5250 error = class_2561.method_48322((String)"cli.msg.info.pagination.error.index", (String)"Invalid page index supplied: %s (Try [0..%s])", (Object[])new Object[]{this.control.pageNumber(), this.control.numberOfPages() - 1});
            throw new InvalidPageNumberException(error, this.control.pageNumber(), this.control.pageSize(), this.control.numberOfPages());
        }
    }

    protected void padEmptyEntries() {
        if (this.control.numberOfPages() > 1) {
            int numberOfEmptyEntries = this.control.pageSize() - this.pageContent.size();
            for (int i = 0; i < numberOfEmptyEntries; ++i) {
                this.paginationLines.add(this.emptyEntry());
            }
        }
    }

    @Override
    public List<T> getContent() {
        return this.pageContent;
    }

    @Override
    public List<class_2561> getLines() {
        if (this.pageContent.isEmpty()) {
            this.paginationLines.add(this.noContentMsg());
            return this.paginationLines;
        }
        this.paginationLines.add(this.header());
        this.paginationLines.addAll(this.buildEntries());
        if (this.control.numberOfPages() > 1) {
            this.padEmptyEntries();
            this.paginationLines.add((class_2561)this.control.build());
        }
        return this.paginationLines;
    }

    public abstract List<class_2561> buildEntries();

    public abstract class_2561 noContentMsg();

    public abstract class_2561 header();

    public abstract class_2561 emptyEntry();
}

