/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.core.area;

import de.z0rdak.yawp.api.core.area.AreaBuilder;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.util.AreaUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class CuboidBuilder
implements AreaBuilder {
    private BlockPos pos1;
    private BlockPos pos2;

    public CuboidBuilder area(BlockPos corner1, BlockPos corner2) {
        this.pos1 = AreaUtil.getLowerPos(corner1, corner2);
        this.pos2 = AreaUtil.getHigherPos(corner1, corner2);
        return this;
    }

    public CuboidBuilder atBlock(BlockPos pos) {
        return this.area(pos, pos);
    }

    public CuboidBuilder around(BlockPos center, int offsetX, int offsetY, int offsetZ) {
        this.pos1 = center.m_7918_(-offsetX, -offsetY, -offsetZ);
        this.pos2 = center.m_7918_(offsetX, offsetY, offsetZ);
        return this;
    }

    public CuboidBuilder startingAt(BlockPos corner, int widthX, int heightY, int depthZ) {
        this.pos1 = corner;
        this.pos2 = corner.m_7918_(widthX, heightY, depthZ);
        return this;
    }

    public CuboidBuilder area(BoundingBox box) {
        BlockPos pos1 = new BlockPos(box.m_162395_(), box.m_162396_(), box.m_162398_());
        BlockPos pos2 = new BlockPos(box.m_162399_(), box.m_162400_(), box.m_162401_());
        return this.area(pos1, pos2);
    }

    @Override
    public CuboidArea build() {
        return new CuboidArea(this.pos1, this.pos2);
    }
}

