/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.events.region;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

@Cancelable
public class ForgeFlagCheckEvent
extends Event {
    private final BlockPos target;
    private final ResourceKey<Level> dimension;
    @Nullable
    private final Player player;
    private final RegionFlag regionFlag;
    private final String id;

    public ForgeFlagCheckEvent(BlockPos target, RegionFlag regionFlag, ResourceKey<Level> dimension, @Nullable Player player) {
        this.player = player;
        this.target = target;
        this.dimension = dimension;
        this.regionFlag = regionFlag;
        this.id = UUID.randomUUID().toString();
    }

    public ForgeFlagCheckEvent(BlockPos target, RegionFlag regionFlag, ResourceKey<Level> dimension, @Nullable Player player, String id) {
        this.player = player;
        this.target = target;
        this.dimension = dimension;
        this.regionFlag = regionFlag;
        this.id = id;
    }

    public ForgeFlagCheckEvent(FlagCheckEvent event) {
        this.player = event.getPlayer();
        this.target = event.getTarget();
        this.dimension = event.getDimension();
        this.regionFlag = event.getRegionFlag();
        this.id = event.getId();
    }

    public ForgeFlagCheckEvent(BlockPos target, RegionFlag regionFlag, ResourceKey<Level> dimension) {
        this(target, regionFlag, dimension, null);
    }

    public String getId() {
        return this.id;
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public RegionFlag getRegionFlag() {
        return this.regionFlag;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }
}

