/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.events.region;

import de.z0rdak.yawp.api.events.region.RegionEvent;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class ForgeRegionEvent
extends Event {
    private final IMarkableRegion region;
    @Nullable
    private final Player player;

    private ForgeRegionEvent(IMarkableRegion region, @Nullable Player player) {
        this.region = region;
        this.player = player;
    }

    public IMarkableRegion getRegion() {
        return this.region;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Cancelable
    public static class Remove
    extends ForgeRegionEvent {
        public Remove(IMarkableRegion region, Player player) {
            super(region, player);
        }

        public Remove(RegionEvent.Remove event) {
            this(event.getRegion(), event.getPlayer());
        }

        public static RegionEvent.Remove asCommonEvent(Remove event) {
            return new RegionEvent.Remove(event.getRegion(), event.getPlayer());
        }
    }

    @Cancelable
    public static class UpdateArea
    extends ForgeRegionEvent {
        private IMarkableArea markedArea;

        public UpdateArea(IMarkableRegion region, IMarkableArea area, Player player) {
            super(region, player);
            this.markedArea = area;
        }

        public UpdateArea(RegionEvent.UpdateArea event) {
            this(event.getRegion(), event.markedArea(), event.getPlayer());
        }

        public static RegionEvent.UpdateArea asCommonEvent(UpdateArea event) {
            return new RegionEvent.UpdateArea(event.getRegion(), event.getMarkedArea(), event.getPlayer());
        }

        public static UpdateArea asEvent(RegionEvent.UpdateArea updateAreaEvent) {
            return new UpdateArea(updateAreaEvent);
        }

        public static RegionEvent.UpdateArea asNonEvent(UpdateArea forgeAreaUpdate) {
            return new RegionEvent.UpdateArea(forgeAreaUpdate.getRegion(), forgeAreaUpdate.getMarkedArea(), forgeAreaUpdate.getPlayer());
        }

        public IMarkableArea getMarkedArea() {
            return this.markedArea;
        }

        public void setMarkedArea(IMarkableArea markedArea) {
            this.markedArea = markedArea;
        }
    }

    @Cancelable
    public static class Rename
    extends ForgeRegionEvent {
        private final String oldName;
        private String newName;

        public Rename(IMarkableRegion region, String oldName, String newName, Player player) {
            super(region, player);
            this.newName = newName;
            this.oldName = oldName;
        }

        public Rename(RegionEvent.Rename event) {
            this(event.getRegion(), event.getOldName(), event.getNewName(), event.getPlayer());
        }

        public static RegionEvent.Rename asCommonEvent(Rename event) {
            return new RegionEvent.Rename(event.getRegion(), event.getOldName(), event.getNewName(), event.getPlayer());
        }

        public String getOldName() {
            return this.oldName;
        }

        public String getNewName() {
            return this.newName;
        }

        public void setNewName(String newName) {
            this.newName = newName;
        }
    }

    @Cancelable
    public static class Create
    extends ForgeRegionEvent {
        public Create(IMarkableRegion region, Player player) {
            super(region, player);
        }

        public Create(RegionEvent.Create event) {
            this(event.getRegion(), event.getPlayer());
        }

        public static RegionEvent.Create asCommonEvent(Create event) {
            return new RegionEvent.Create(event.getRegion(), event.getPlayer());
        }
    }
}

