/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.commands.arguments.AreaArgumentType;
import de.z0rdak.yawp.commands.arguments.LevelRegionDataArgumentType;
import de.z0rdak.yawp.commands.arguments.flag.IFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.flag.RegionFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.LevelRegionData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class ArgumentUtil {
    public static LiteralArgumentBuilder<CommandSourceStack> literal(CommandConstants constant) {
        return Commands.m_82127_((String)constant.toString());
    }

    public static LevelRegionData getLevelDataArgument(CommandContext<CommandSourceStack> ctx) {
        try {
            return LevelRegionDataArgumentType.getDimRegion(ctx, CommandConstants.DIM.toString());
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static DimensionalRegion getDimRegionFromArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return LevelRegionDataArgumentType.getDimRegion(ctx, CommandConstants.DIM.toString()).getDim();
    }

    public static GlobalRegion getGlobalRegion() {
        return RegionManager.get().getGlobalRegion();
    }

    public static AreaType getAreaTypeArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return AreaArgumentType.getAreaType(ctx);
    }

    public static String getRegionNameArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.NAME.toString());
    }

    public static DisplayType getDisplayTypeArgument(CommandContext<CommandSourceStack> ctx) {
        String displayType = StringArgumentType.getString(ctx, (String)CommandConstants.STYLE.toString());
        return DisplayType.of(displayType);
    }

    public static ResourceLocation getDisplayBlockArgument(CommandContext<CommandSourceStack> ctx) {
        return ResourceLocationArgument.m_107011_(ctx, (String)CommandConstants.BLOCK.toString());
    }

    public static BlockPos getTeleportAnchorPosArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return BlockPosArgument.m_174395_(ctx, (String)CommandConstants.TP_ANCHOR.toString());
    }

    public static String getTeleportAnchorNameArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.NAME.toString());
    }

    public static String getNewTeleportAnchorNameArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.RENAME.toString());
    }

    public static boolean getDisplayGlowArgument(CommandContext<CommandSourceStack> ctx) {
        return BoolArgumentType.getBool(ctx, (String)CommandConstants.GLOW.toString());
    }

    public static IMarkableRegion getRegionArgument(CommandContext<CommandSourceStack> ctx) {
        try {
            return RegionArgumentType.getRegion(ctx, CommandConstants.LOCAL.toString());
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static IMarkableRegion getRegionIn(CommandContext<CommandSourceStack> ctx, Level level) {
        try {
            return RegionArgumentType.getRegionIn(ctx, CommandConstants.LOCAL.toString(), level);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static IProtectedRegion getRegion(CommandContext<CommandSourceStack> ctx, RegionType regionType) throws CommandSyntaxException {
        return RegionArgumentType.getRegion(ctx, regionType);
    }

    public static IProtectedRegion getTargetLocalRegionArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionArgumentType.getTargetRegion(ctx, CommandConstants.TARGET_REGION.toString());
    }

    public static LevelRegionData getTargetDimRegionArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return LevelRegionDataArgumentType.getDimRegion(ctx, CommandConstants.TARGET_DIM.toString());
    }

    public static IMarkableRegion getChildRegionArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionArgumentType.getRegion(ctx, CommandConstants.CHILD.toString());
    }

    public static IMarkableRegion getContainingOwnedRegionArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ContainingOwnedRegionArgumentType.getRegion(ctx, CommandConstants.PARENT.toString());
    }

    public static IMarkableRegion getContainingOwnedRegionArgumentWithMarker(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return ContainingOwnedRegionArgumentType.getRegionWithMarker(ctx, CommandConstants.PARENT.toString());
    }

    public static ServerPlayer getPlayerArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return EntityArgument.m_91474_(ctx, (String)CommandConstants.PLAYER.toString());
    }

    public static Collection<ServerPlayer> getPlayersArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return EntityArgument.m_91477_(ctx, (String)CommandConstants.PLAYER.toString());
    }

    public static UUID getPlayerUUIDArgument(CommandContext<CommandSourceStack> ctx) {
        return UuidArgument.m_113853_(ctx, (String)CommandConstants.PLAYER_UUID.toString());
    }

    public static List<String> getPlayerNamesArgument(CommandContext<CommandSourceStack> ctx) {
        String[] names = StringArgumentType.getString(ctx, (String)CommandConstants.PLAYER_NAMES.toString()).split(" ");
        return Arrays.asList(names);
    }

    public static String getFlagNameArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.FLAG.toString());
    }

    public static RegionFlag getFlagArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionFlagArgumentType.getFlag(ctx, CommandConstants.FLAG.toString());
    }

    public static Set<RegionFlag> getFlagArguments(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return RegionFlagArgumentType.getFlags(ctx, CommandConstants.FLAGS.toString());
    }

    @Nullable
    public static IFlag getIFlagArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return IFlagArgumentType.getFlag(ctx, CommandConstants.FLAG.toString());
    }

    public static String getFlagMsgArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.MSG.toString());
    }

    public static FlagType getFlagTypeArgument(CommandContext<CommandSourceStack> ctx) {
        return FlagType.of(StringArgumentType.getString(ctx, (String)CommandConstants.TYPE.toString()));
    }

    public static String getGroupArgument(CommandContext<CommandSourceStack> ctx) {
        return StringArgumentType.getString(ctx, (String)CommandConstants.GROUP.toString());
    }

    public static ServerPlayer getOwnerArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return EntityArgument.m_91474_(ctx, (String)CommandConstants.OWNER.toString());
    }

    public static Team getTeamArgument(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return TeamArgument.m_112091_(ctx, (String)CommandConstants.TEAM.toString());
    }

    public static boolean getAlertArgument(CommandContext<CommandSourceStack> ctx) {
        return BoolArgumentType.getBool(ctx, (String)CommandConstants.ALERT.toString());
    }

    public static boolean muteArgument(CommandContext<CommandSourceStack> ctx) {
        return BoolArgumentType.getBool(ctx, (String)CommandConstants.MUTE.toString());
    }

    public static boolean getEnableArgument(CommandContext<CommandSourceStack> ctx) {
        return BoolArgumentType.getBool(ctx, (String)CommandConstants.ENABLE.toString());
    }

    public static FlagState getFlagStateArgument(CommandContext<CommandSourceStack> ctx) {
        String state = StringArgumentType.getString(ctx, (String)CommandConstants.STATE.toString());
        return FlagState.from(state);
    }

    public static boolean getOverrideArgument(CommandContext<CommandSourceStack> ctx) {
        return BoolArgumentType.getBool(ctx, (String)CommandConstants.OVERRIDE.toString());
    }

    public static int getPriorityArgument(CommandContext<CommandSourceStack> ctx) {
        return IntegerArgumentType.getInteger(ctx, (String)CommandConstants.PRIORITY.toString());
    }

    public static int getPageNoArgument(CommandContext<CommandSourceStack> ctx) {
        return IntegerArgumentType.getInteger(ctx, (String)CommandConstants.PAGE.toString());
    }

    public static String revertCommand(String cmd, CommandConstants toReplace, CommandConstants reverted) {
        String revertedCmd = cmd.replace(toReplace.toString(), reverted.toString());
        return cmd.startsWith("/") ? revertedCmd : "/" + revertedCmd;
    }

    public static String revertCommand(String cmd, String toReplace, String reverted) {
        String revertedCmd = cmd.replace(toReplace, reverted);
        return cmd.startsWith("/") ? revertedCmd : "/" + revertedCmd;
    }
}

