/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.region;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.commands.MarkerCommands;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ContainingOwnedRegionArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z]+[A-Za-z\\d\\-]+[A-Za-z\\d]+$");
    private static final Collection<String> EXAMPLES = Stream.of("spawn", "arena4pvp", "shop", "nether-hub").collect(Collectors.toSet());
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)Component.m_264568_((String)"cli.arg.region.parse.invalid", (String)"Unable to parse region name!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(regionName -> Component.m_264642_((String)"cli.arg.region.invalid", (String)"Region '%s' does not exist", (Object[])new Object[]{regionName}));
    private static final DynamicCommandExceptionType ERROR_INVALID_PARENT = new DynamicCommandExceptionType(regionName -> Component.m_264642_((String)"cli.arg.region.owned.invalid", (String)"Region '%s' is not suitable as parent", (Object[])new Object[]{regionName}));

    public static ContainingOwnedRegionArgumentType owningRegions() {
        return new ContainingOwnedRegionArgumentType();
    }

    public static IMarkableRegion getRegion(CommandContext<CommandSourceStack> context, String argName) throws CommandSyntaxException {
        String containingRegionName = (String)context.getArgument(argName, String.class);
        String containedRegionName = (String)context.getArgument(CommandConstants.NAME.toString(), String.class);
        LevelRegionData levelRegionData = RegionDataManager.getOrCreate((Level)((CommandSourceStack)context.getSource()).m_81372_());
        IMarkableRegion parent = levelRegionData.getLocal(containingRegionName);
        IMarkableArea markedArea = ContainingOwnedRegionArgumentType.markableArea(context);
        if (markedArea == null) {
            throw new IllegalArgumentException("Could not get marked blocks from command");
        }
        if (parent == null) {
            throw ERROR_INVALID_VALUE.create((Object)containingRegionName);
        }
        boolean hasPermissionForParent = Permissions.get().hasConfigPermission((CommandSourceStack)context.getSource(), CommandSourceType.of((CommandSourceStack)context.getSource()));
        boolean containsChild = parent.getArea().containsOther(markedArea);
        if (hasPermissionForParent && containsChild) {
            return parent;
        }
        if (!hasPermissionForParent) {
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.m_264642_((String)"cli.arg.region.owned.invalid.permission", (String)"Region %s is not suitable as parent for %s (no permission for parent)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        if (!containsChild) {
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.m_264642_((String)"cli.arg.region.owned.invalid.containment", (String)"Region %s is not suitable as parent for %s (does not fully contain child region)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        throw ERROR_INVALID_PARENT.create((Object)containingRegionName);
    }

    public static IMarkableRegion getRegionWithMarker(CommandContext<CommandSourceStack> context, String argName) throws CommandSyntaxException {
        String containingRegionName = (String)context.getArgument(argName, String.class);
        String containedRegionName = (String)context.getArgument(CommandConstants.NAME.toString(), String.class);
        LevelRegionData levelData = RegionDataManager.getOrCreate((Level)((CommandSourceStack)context.getSource()).m_81372_());
        IMarkableRegion parent = levelData.getLocal(containingRegionName);
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        IMarkableRegion markedRegion = MarkerCommands.fromMarkedBlocks(context, (Player)player, containedRegionName);
        if (markedRegion == null) {
            throw new IllegalArgumentException("Could not get marked blocks from command");
        }
        if (parent == null) {
            throw ERROR_INVALID_VALUE.create((Object)containingRegionName);
        }
        boolean hasPermissionForParent = Permissions.get().hasConfigPermission((CommandSourceStack)context.getSource(), CommandSourceType.of((CommandSourceStack)context.getSource()));
        boolean containsChild = parent.getArea().containsOther(markedRegion.getArea());
        if (hasPermissionForParent && containsChild) {
            return parent;
        }
        if (!hasPermissionForParent) {
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.m_264642_((String)"cli.arg.region.owned.invalid.permission", (String)"Region %s is not suitable as parent for %s (no permission for parent)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        if (!containsChild) {
            MessageSender.sendCmdFeedback((CommandSourceStack)context.getSource(), Component.m_264642_((String)"cli.arg.region.owned.invalid.containment", (String)"Region %s is not suitable as parent for %s (does not fully contain child region)", (Object[])new Object[]{containingRegionName, containedRegionName}));
        }
        throw ERROR_INVALID_PARENT.create((Object)containingRegionName);
    }

    @Nullable
    private static IMarkableArea markableArea(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        MarkedArea markedArea = null;
        AreaType areaType = null;
        if (ctx.getInput().contains(AreaType.CUBOID.areaType)) {
            areaType = AreaType.CUBOID;
        }
        if (ctx.getInput().contains(AreaType.SPHERE.areaType)) {
            areaType = AreaType.SPHERE;
        }
        switch (areaType) {
            case CUBOID: {
                BlockPos p1 = BlockPosArgument.m_174395_(ctx, (String)CommandConstants.POS1.toString());
                BlockPos p2 = BlockPosArgument.m_174395_(ctx, (String)CommandConstants.POS2.toString());
                markedArea = new CuboidArea(p1, p2);
                break;
            }
            case SPHERE: {
                try {
                    BlockPos centerPos = BlockPosArgument.m_174395_(ctx, (String)CommandConstants.CENTER_POS.toString());
                    int radius = IntegerArgumentType.getInteger(ctx, (String)CommandConstants.RADIUS.toString());
                    markedArea = new SphereArea(centerPos, radius);
                }
                catch (CommandSyntaxException cse) {
                    BlockPos centerPos = BlockPosArgument.m_174395_(ctx, (String)CommandConstants.CENTER_POS.toString());
                    BlockPos radiusPos = BlockPosArgument.m_174395_(ctx, (String)CommandConstants.RADIUS_POS.toString());
                    markedArea = new SphereArea(centerPos, radiusPos);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)areaType));
            }
        }
        return markedArea;
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_NAME_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid region name supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing region name");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestionsWithMarker(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack src = (CommandSourceStack)object;
            try {
                CompoundTag stickNBT;
                ServerPlayer player = src.m_81375_();
                ItemStack maybeStick = player.m_21205_();
                if (StickUtil.isMarker(maybeStick) && (stickNBT = StickUtil.getStickNBT(maybeStick)) != null) {
                    MarkerStick marker = new MarkerStick(stickNBT);
                    if (!marker.isValidArea()) {
                        return Suggestions.empty();
                    }
                    IMarkableArea markedArea = StickUtil.getMarkedArea(player.m_21205_());
                    LocalRegions.RegionOverlappingInfo overlapping = LocalRegions.getOverlappingWithPermission(markedArea, (Player)player);
                    if (!overlapping.hasContaining()) {
                        MessageSender.overLayMessage((Player)src.m_230896_(), Component.m_264568_((String)"cli.arg.area.marked.no-containment", (String)"No containing region available as parent for marked area."));
                        return Suggestions.empty();
                    }
                    Set containingRegionName = overlapping.containingRegions.stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
                    return SharedSuggestionProvider.m_82970_(containingRegionName, (SuggestionsBuilder)builder);
                }
                return Suggestions.empty();
            }
            catch (CommandSyntaxException e) {
                Constants.LOGGER.error((Object)e);
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof CommandSourceStack) {
            CommandSourceStack src = (CommandSourceStack)object;
            CommandContext<S> ctx = context;
            try {
                LocalRegions.RegionOverlappingInfo overlapping;
                IMarkableArea markedArea = ContainingOwnedRegionArgumentType.markableArea(ctx);
                if (markedArea == null) {
                    throw new IllegalArgumentException("Could not get marked blocks from command");
                }
                try {
                    ServerPlayer player = src.m_81375_();
                    overlapping = LocalRegions.getOverlappingWithPermission(markedArea, (Player)player);
                }
                catch (CommandSyntaxException e) {
                    overlapping = LocalRegions.getOverlappingRegions(markedArea, (ResourceKey<Level>)src.m_81372_().m_46472_());
                }
                if (!overlapping.hasContaining()) {
                    if (src.m_230897_()) {
                        MessageSender.overLayMessage((Player)src.m_230896_(), Component.m_264568_((String)"cli.arg.area.owned.no-containment", (String)"No containing region available as parent for given area."));
                        return Suggestions.empty();
                    }
                    MessageSender.sendCmdFeedback(src, Component.m_264568_((String)"cli.arg.area.owned.no-containment", (String)"No containing region available as parent for given area."));
                    return Suggestions.empty();
                }
                Set containingRegionName = overlapping.containingRegions.stream().map(IProtectedRegion::getName).collect(Collectors.toSet());
                return SharedSuggestionProvider.m_82970_(containingRegionName, (SuggestionsBuilder)builder);
            }
            catch (CommandSyntaxException e) {
                return Suggestions.empty();
            }
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

