/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.CenteredArea;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.core.area.MarkedAreaTypes;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.NotImplementedException;

public class SphereArea
extends CenteredArea {
    public static Codec<SphereArea> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.f_121852_.fieldOf("center").forGetter(CenteredArea::getCenterPos), (App)Codec.INT.fieldOf("radius").forGetter(SphereArea::getRadius), (App)Codec.STRING.fieldOf("areaType").forGetter(r -> MarkedAreaTypes.areaIdentifier(r.getAreaType()).toString()), (App)BlockDisplayProperties.CODEC.fieldOf("display").orElse((Object)BlockDisplayProperties.createRndDefault()).forGetter(MarkedArea::getDisplay)).apply((Applicative)instance, (center, radius, area, display) -> {
        SphereArea sphere = new SphereArea((BlockPos)center, (int)radius);
        sphere.updateDisplay((BlockDisplayProperties)display);
        return sphere;
    }));
    private final int radius;

    public SphereArea(BlockPos centerPos, BlockPos scopePos) {
        super(centerPos, AreaType.SPHERE);
        this.radius = (int)(AreaUtil.distance(centerPos, scopePos) + 0.5);
    }

    public SphereArea(BlockPos middlePos, int radius) {
        this(middlePos, new BlockPos((Vec3i)middlePos).m_7918_(0, radius, 0));
    }

    public static SphereArea expand(SphereArea area, int expansion) {
        SphereArea expanded = new SphereArea(area.center, Math.max(area.radius + expansion, 0));
        expanded.updateDisplay(area.getDisplay());
        return expanded;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return AreaUtil.distance(this.center, pos) < (double)this.radius + 0.5;
    }

    public boolean isHullBlock(BlockPos pos) {
        double d = AreaUtil.distance(this.center, pos);
        return d > (double)this.radius - 0.5 && d < (double)this.radius + 0.5;
    }

    @Override
    public Set<BlockPos> getHull() {
        BlockPos p1 = this.center.m_7918_(-this.radius, -this.radius, -this.radius);
        BlockPos p2 = new BlockPos((Vec3i)this.center).m_7918_(this.radius, this.radius, this.radius);
        BoundingBox cube = BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
        Set<BlockPos> cubeBlocks = AreaUtil.blocksIn(cube);
        return cubeBlocks.stream().filter(this::isHullBlock).collect(Collectors.toSet());
    }

    @Override
    public Set<BlockPos> getFrame() {
        Set<BlockPos> frameBlocks = this.getMinimalOutline();
        int halfRadius = this.radius / 2;
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, Direction.Axis.X, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, Direction.Axis.X, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, Direction.Axis.Y, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, Direction.Axis.Y, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, Direction.Axis.Z, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, Direction.Axis.Z, this::isHullBlock));
        return frameBlocks;
    }

    @Override
    public Set<BlockPos> getMinimalOutline() {
        HashSet<BlockPos> frameBlocks = new HashSet<BlockPos>();
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, Direction.Axis.X, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, Direction.Axis.Y, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, Direction.Axis.Z, this::isHullBlock));
        return frameBlocks;
    }

    public boolean contains(CuboidArea inner) {
        double maxDistance = Double.NEGATIVE_INFINITY;
        for (BlockPos vertex : inner.getVertices()) {
            double distance = AreaUtil.distanceManhattan(this.center, vertex);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        return maxDistance <= (double)this.getRadius();
    }

    public boolean contains(SphereArea inner) {
        return AreaUtil.distanceManhattan(this.center, inner.center) + inner.radius <= this.radius;
    }

    public boolean intersects(CuboidArea other) {
        int closestZ;
        int closestY;
        if (other.contains(this.center)) {
            return true;
        }
        int closestX = Math.max(other.getArea().m_162395_(), Math.min(this.center.m_123341_(), other.getArea().m_162399_()));
        return AreaUtil.distanceManhattan(this.center, new BlockPos(closestX, closestY = Math.max(other.getArea().m_162396_(), Math.min(this.center.m_123342_(), other.getArea().m_162400_())), closestZ = Math.max(other.getArea().m_162398_(), Math.min(this.center.m_123343_(), other.getArea().m_162401_())))) <= this.radius;
    }

    public boolean intersects(SphereArea other) {
        return AreaUtil.distanceManhattan(this.center, other.center) <= this.radius + other.radius;
    }

    @Override
    public boolean containsOther(IMarkableArea inner) {
        switch (inner.getAreaType()) {
            case CUBOID: {
                return this.contains((CuboidArea)inner);
            }
            case SPHERE: {
                return this.contains((SphereArea)inner);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        switch (other.getAreaType()) {
            case CUBOID: {
                return this.intersects((CuboidArea)other);
            }
            case SPHERE: {
                return this.intersects((SphereArea)other);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return MarkedAreaTypes.SPHERE_AREA;
    }

    public String toString() {
        return "Sphere " + AreaUtil.blockPosStr(this.center) + ", r=" + this.radius;
    }
}

