/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;

public final class TextDisplayProperties {
    public static int BG_TRANSPARENT = 0x10000000;
    private String text;
    private String alignment;
    private int backgroundColor;
    private String color;
    private int lightLevel;
    public static final int DEFAULT_BACKGROUND = 0x1A000000;

    public TextDisplayProperties(String text, String alignment, int backgroundColor, String color, int lightLevel) {
        this.text = text;
        this.alignment = alignment;
        this.backgroundColor = backgroundColor;
        ChatFormatting colorFormat = ChatFormatting.m_126657_((String)color);
        this.color = colorFormat == null ? ChatFormatting.WHITE.m_126666_() : colorFormat.m_126666_();
        this.lightLevel = lightLevel;
    }

    public TextDisplayProperties(String text) {
        this.text = text;
        this.alignment = "center";
        this.backgroundColor = BG_TRANSPARENT;
        this.color = ChatFormatting.WHITE.toString();
        this.lightLevel = 15;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("text", this.text);
        tag.m_128359_("alignment", this.alignment);
        tag.m_128405_("backgroundColor", this.backgroundColor);
        tag.m_128359_("color", this.color);
        tag.m_128405_("lightLevel", this.lightLevel);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.text = nbt.m_128461_("text");
        this.alignment = nbt.m_128461_("alignment");
        this.backgroundColor = nbt.m_128451_("backgroundColor");
        ChatFormatting colorFormat = ChatFormatting.m_126657_((String)this.color);
        this.color = colorFormat == null ? ChatFormatting.WHITE.m_126666_() : colorFormat.m_126666_();
        this.lightLevel = nbt.m_128451_("lightLevel");
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getColor() {
        return this.color;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }
}

