/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.group;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.group.IMemberContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;

public class PlayerContainer
implements IMemberContainer {
    public static final Codec<PlayerContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(pc -> pc.groupName), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("teams", new ArrayList()).forGetter(pc -> new ArrayList<String>(pc.teams)), (App)Codec.unboundedMap((Codec)UUIDUtil.f_260719_, (Codec)Codec.STRING).optionalFieldOf("players", new HashMap()).forGetter(pc -> pc.players)).apply((Applicative)instance, PlayerContainer::new));
    private final Set<String> teams;
    private final Map<UUID, String> players;
    private final String groupName;

    public PlayerContainer(String groupName) {
        this.groupName = groupName;
        this.teams = new HashSet<String>(0);
        this.players = new HashMap<UUID, String>(0);
    }

    public PlayerContainer(String groupName, List<String> teams, Map<UUID, String> players) {
        this(groupName);
        this.teams.addAll(teams);
        this.players.putAll(players);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    public Set<String> getTeams() {
        return this.teams;
    }

    public Map<UUID, String> getPlayers() {
        return this.players;
    }

    @Override
    public boolean hasTeams() {
        return !this.teams.isEmpty();
    }

    @Override
    public boolean hasPlayers() {
        return !this.players.isEmpty();
    }

    @Override
    public boolean hasPlayer(UUID playerUUID) {
        return this.players.containsKey(playerUUID);
    }

    @Override
    public boolean hasTeam(String team) {
        return this.teams.contains(team);
    }

    @Override
    public void addPlayer(UUID uuid, String name) {
        this.players.put(uuid, name);
    }

    @Override
    public void addTeam(String team) {
        this.teams.add(team);
    }

    @Override
    public void clearPlayers() {
        this.players.clear();
    }

    @Override
    public void removePlayer(UUID playerUUID) {
        this.players.remove(playerUUID);
    }

    @Override
    public void removeTeam(String team) {
        this.teams.remove(team);
    }

    @Override
    public void clearTeams() {
        this.teams.clear();
    }
}

