/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.stick;

import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.util.StickType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class MarkerStick
extends AbstractStick
implements INbtSerializable<CompoundTag> {
    private ResourceKey<Level> dimension;
    private AreaType areaType;
    private boolean isValidArea;
    private List<BlockPos> markedBlocks;

    public MarkerStick(ResourceKey<Level> dim) {
        super(StickType.MARKER);
        this.areaType = AreaType.CUBOID;
        this.isValidArea = false;
        this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
        this.dimension = dim;
    }

    public MarkerStick(CompoundTag nbt) {
        super(StickType.MARKER);
        this.deserializeNBT(nbt);
    }

    @Override
    public void cycleMode() {
        this.areaType = AreaType.values()[(this.areaType.ordinal() + 1) % AreaType.values().length];
        this.reset();
    }

    public void reset() {
        this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
        this.isValidArea = false;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public boolean checkValidArea() {
        int numMarkedBlocks = this.markedBlocks.size();
        if (this.markedBlocks.isEmpty() || this.areaType.neededBlocks == -1) {
            return false;
        }
        boolean exactlyEnoughBlocks = numMarkedBlocks == this.areaType.neededBlocks && numMarkedBlocks == this.areaType.maxBlocks;
        boolean minBlocks = numMarkedBlocks >= this.areaType.neededBlocks && numMarkedBlocks <= this.areaType.maxBlocks;
        this.isValidArea = exactlyEnoughBlocks || minBlocks;
        return this.isValidArea;
    }

    public AreaType getAreaType() {
        return this.areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public boolean isValidArea() {
        return this.isValidArea;
    }

    public List<BlockPos> getMarkedBlocks() {
        return this.markedBlocks;
    }

    public void addMarkedBlock(BlockPos pos) {
        int index = this.markedBlocks.size() % this.areaType.maxBlocks;
        this.markedBlocks.add(index, pos);
        if (this.markedBlocks.size() > this.areaType.maxBlocks) {
            this.markedBlocks.remove(this.areaType.maxBlocks);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("stick-id", UUID.randomUUID().toString());
        nbt.m_128379_("valid", this.isValidArea);
        nbt.m_128359_("type", this.areaType.areaType);
        nbt.m_128359_("dim", this.dimension.m_135782_().toString());
        ListTag blocks = new ListTag();
        this.markedBlocks.forEach(block -> blocks.add((Object)NbtUtils.m_129224_((BlockPos)block)));
        nbt.m_128365_("blocks", (Tag)blocks);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.isValidArea = nbt.m_128471_("valid");
        this.areaType = AreaType.of(nbt.m_128461_("type"));
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim")));
        ListTag markedBlocksNBT = nbt.m_128437_("blocks", 10);
        this.markedBlocks = new ArrayList<BlockPos>(this.areaType.maxBlocks);
        markedBlocksNBT.forEach(block -> this.markedBlocks.add(NbtUtils.m_129239_((CompoundTag)((CompoundTag)block))));
    }
}

