/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelListData
extends SavedData {
    public static final String DIMENSIONS_FILE_NAME = "dimensions";
    public static Codec<LevelListData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.f_135803_).optionalFieldOf("dims", new ArrayList()).forGetter(LevelListData::getLevels)).apply((Applicative)instance, LevelListData::new));
    public static final String TYPE = String.join((CharSequence)"/", "yawp", "dimensions");
    private final Set<ResourceLocation> dimensions;

    public LevelListData(List<ResourceLocation> dims) {
        this.dimensions = new HashSet<ResourceLocation>(dims);
    }

    public LevelListData() {
        this.dimensions = new HashSet<ResourceLocation>();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        Optional nbt = CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).resultOrPartial(arg_0 -> ((Logger)Constants.LOGGER).warn(arg_0));
        if (nbt.isPresent()) {
            tag = (CompoundTag)nbt.get();
        }
        return tag;
    }

    public static LevelListData get(DimensionDataStorage storage, @Nullable Supplier<LevelListData> defaultSupplier) {
        return (LevelListData)storage.m_164861_(LevelListData::load, defaultSupplier == null ? LevelListData::new : defaultSupplier, TYPE);
    }

    public static LevelListData load(CompoundTag tag) {
        return CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(arg_0 -> ((Logger)Constants.LOGGER).warn(arg_0)).orElse(new LevelListData());
    }

    public List<ResourceLocation> getLevels() {
        return new ArrayList<ResourceLocation>(this.dimensions);
    }

    public void addDimEntry(ResourceLocation rl) {
        this.dimensions.add(rl);
    }

    public boolean hasDimEntry(ResourceLocation rl) {
        return this.dimensions.contains(rl);
    }
}

