/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.core.flag.FlagCorrelation;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public final class HandlerUtil {
    private HandlerUtil() {
    }

    public static ResourceKey<Level> getDimKey(Entity entity) {
        return entity.m_9236_().m_46472_();
    }

    public static ResourceKey<Level> getDimKey(Level world) {
        return world.m_46472_();
    }

    public static boolean isAnimal(Entity entity) {
        boolean isMonsterHorse = entity instanceof ZombieHorse || entity instanceof SkeletonHorse;
        return entity instanceof Animal && !isMonsterHorse || entity instanceof WaterAnimal;
    }

    public static boolean isServerSide(Entity entity) {
        return HandlerUtil.isServerSide(entity.m_9236_());
    }

    public static boolean isServerSide(LevelAccessor world) {
        return !world.m_5776_();
    }

    public static boolean isServerSide(Level world) {
        return !world.f_46443_;
    }

    public static boolean isVillager(Entity entity) {
        return entity instanceof Merchant;
    }

    public static boolean isMonster(Entity entity) {
        return entity instanceof Enemy || entity instanceof Slime || entity instanceof FlyingMob || entity instanceof EnderDragon || entity instanceof Shulker || entity instanceof ZombieHorse || entity instanceof SkeletonHorse;
    }

    public static boolean notServerSideOrPlayerNull(Entity entity) {
        return entity == null || !HandlerUtil.isServerSide(entity);
    }

    public static void syncPlayerInventory(Level world, Player player) {
    }

    public static void updateBlockState(Level world, BlockPos pos) {
        world.m_46672_(pos, world.m_8055_(pos).m_60734_());
    }

    public static Map<String, FlagCorrelation> getFlagMapRecursive(IProtectedRegion region, Map<String, FlagCorrelation> carry) {
        if (carry == null) {
            carry = region.getFlags().flagEntries().stream().filter(flag -> ((IFlag)flag.getValue()).getState() != FlagState.UNDEFINED).collect(Collectors.toMap(Map.Entry::getKey, entry -> new FlagCorrelation(region, (IFlag)entry.getValue())));
        }
        if (region.equals(region.getParent())) {
            Set<Map.Entry<String, IFlag>> flags = HandlerUtil.getNonUndefinedFlags(region);
            for (Map.Entry<String, IFlag> entry2 : flags) {
                if (carry.containsKey(entry2.getKey())) continue;
                carry.put(entry2.getValue().getName(), new FlagCorrelation(region, entry2.getValue()));
            }
            return carry;
        }
        Set<Map.Entry<String, IFlag>> parentFlags = HandlerUtil.getNonUndefinedFlags(region.getParent());
        for (Map.Entry<String, IFlag> entry3 : parentFlags) {
            if (!carry.containsKey(entry3.getKey())) {
                carry.put(entry3.getValue().getName(), new FlagCorrelation(region.getParent(), entry3.getValue()));
            }
            if (!entry3.getValue().doesOverride()) continue;
            carry.put(entry3.getValue().getName(), new FlagCorrelation(region.getParent(), entry3.getValue()));
        }
        return HandlerUtil.getFlagMapRecursive(region.getParent(), carry);
    }

    private static Set<Map.Entry<String, IFlag>> getNonUndefinedFlags(IProtectedRegion region) {
        return region.getFlags().flagEntries().stream().filter(flag -> ((IFlag)flag.getValue()).getState() != FlagState.UNDEFINED).collect(Collectors.toSet());
    }
}

