/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.util.StickType;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MarkerStickHandler {
    public static void onCreateStick(Player player, ItemStack input, ItemStack output, StickType type) {
        input.m_41764_(output.m_41613_() - 1);
        player.m_36356_(input);
        player.m_6749_(1);
        StickUtil.initMarkerNbt(output, (ResourceKey<Level>)player.m_9236_().m_46472_());
    }

    public static void onMarkBlock(Player player, ItemStack involvedItem, BlockPos target) {
        StickType stickType;
        if (HandlerUtil.isServerSide(player.m_9236_()) && !involvedItem.equals(ItemStack.f_41583_) && StickUtil.isVanillaStick(involvedItem) && Objects.requireNonNull(stickType = StickUtil.getStickType(involvedItem)) == StickType.MARKER) {
            MarkerStick marker = new MarkerStick(involvedItem.m_41783_().m_128469_("stick"));
            AreaType areaType = marker.getAreaType();
            if (areaType == null) {
                Constants.LOGGER.warn("Unknown area type on marking - should really not happening");
                return;
            }
            marker.addMarkedBlock(target);
            marker.checkValidArea();
            involvedItem.m_41783_().m_128365_("stick", (Tag)marker.serializeNBT());
            StickUtil.setStickName(involvedItem, StickType.MARKER);
        }
    }

    public static void onCycleMode(Player player, ItemStack involvedItem, BlockHitResult target) {
        if (HandlerUtil.isServerSide(player.m_9236_()) && !involvedItem.equals(ItemStack.f_41583_) && StickUtil.hasNonNullTag(involvedItem) && involvedItem.m_41783_().m_128441_("stick")) {
            StickType stickType;
            boolean targetIsAir;
            if (target.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos blockpos = target.m_82425_();
                BlockState blockstate = player.m_9236_().m_8055_(blockpos);
                targetIsAir = blockstate.m_60734_().equals(Blocks.f_50016_);
            } else {
                boolean bl = targetIsAir = target.m_6662_() == HitResult.Type.MISS;
            }
            if (player.m_6144_() && targetIsAir && Objects.requireNonNull(stickType = StickUtil.getStickType(involvedItem)) == StickType.MARKER) {
                CompoundTag nbt = involvedItem.m_41783_();
                MarkerStick marker = new MarkerStick(nbt.m_128469_("stick"));
                marker.cycleMode();
                involvedItem.m_41783_().m_128365_("stick", (Tag)marker.serializeNBT());
                StickUtil.setStickName(involvedItem, StickType.MARKER);
            }
        }
    }
}

