/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/world/entity/EquipmentSlot;CHEST:Lnet/minecraft/world/entity/EquipmentSlot;")}, method={"tryToStartFallFlying()Z"}, allow=1, cancellable=true)
    void injectElytraCheck(CallbackInfoReturnable<Boolean> cir) {
        Player self = (Player)this;
        if (HandlerUtil.isServerSide(self.m_9236_())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.m_20183_(), RegionFlag.USE_ELYTRA, HandlerUtil.getDimKey((Entity)self), self);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, denyResult -> cir.setReturnValue((Object)false));
        }
    }

    @Inject(method={"dropEquipment"}, at={@At(value="HEAD")}, allow=1, cancellable=true)
    void onDropEquipment(CallbackInfo ci) {
        Player self = (Player)this;
        if (HandlerUtil.isServerSide(self.m_9236_())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.m_20183_(), RegionFlag.KEEP_INV, HandlerUtil.getDimKey((Entity)self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.process(checkEvent).onAllow(res -> ci.cancel());
        }
    }

    @Inject(method={"causeFoodExhaustion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;addExhaustion(F)V")}, cancellable=true, allow=1)
    public void onGainHunger(float exhaustion, CallbackInfo ci) {
        Player self = (Player)this;
        if (HandlerUtil.isServerSide((Entity)self)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.m_20183_(), RegionFlag.NO_HUNGER, HandlerUtil.getDimKey((Entity)self), self);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.process(checkEvent).onAllow(res -> ci.cancel());
        }
    }
}

