/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.PlayerManager;
import de.z0rdak.yawp.util.AreaUtil;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public class ChatComponentBuilder {
    private ChatComponentBuilder() {
    }

    public static String commandBlockPosStr(BlockPos target) {
        return target.m_123341_() + " " + target.m_123342_() + " " + target.m_123343_();
    }

    public static String shortBlockPosBracketed(BlockPos target) {
        return "[" + ChatComponentBuilder.shortBlockPos(target) + "]";
    }

    public static String shortBlockPos(BlockPos target) {
        return "X=" + target.m_123341_() + ", Y=" + target.m_123342_() + ", Z=" + target.m_123343_();
    }

    public static String tinyBlockPos(BlockPos target) {
        return "[" + ChatComponentBuilder.commandBlockPosStr(target) + "]";
    }

    public static String buildBlockPosLinkText(BlockPos target) {
        return target.m_123341_() + ", " + target.m_123342_() + ", " + target.m_123343_();
    }

    public static MutableComponent buildHeader(MutableComponent header) {
        return header;
    }

    public static MutableComponent buildExecuteCmdComponent(MutableComponent linkText, MutableComponent hoverText, String command, ClickEvent.Action eventAction, ChatFormatting color) {
        MutableComponent text = ComponentUtils.m_130748_((Component)linkText);
        return text.m_6270_(text.m_7383_().m_131140_(color).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)).m_131142_(new ClickEvent(eventAction, command)));
    }

    public static MutableComponent buildExecuteCmdLink(MutableComponent linkText, MutableComponent hoverText, String command, ClickEvent.Action eventAction, ChatFormatting color) {
        return linkText.m_6270_(linkText.m_7383_().m_131140_(color).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)).m_131142_(new ClickEvent(eventAction, command)));
    }

    public static MutableComponent buildExecuteCmdLinkWithBrackets(MutableComponent linkText, MutableComponent hoverText, String command, ClickEvent.Action eventAction, ChatFormatting color) {
        MutableComponent cmdLink = linkText.m_6270_(linkText.m_7383_().m_131140_(color).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)).m_131142_(new ClickEvent(eventAction, command)));
        return ComponentUtils.m_130748_((Component)cmdLink);
    }

    public static MutableComponent buildPlayerHoverComponent(Player player) {
        MutableComponent playerName = Component.m_237113_((String)player.m_6302_());
        MutableComponent playerInfo = Messages.substitutable("%s (%s)", player.m_5446_(), player.m_20148_().toString());
        playerName.m_6270_(playerName.m_7383_().m_131140_(Messages.LINK_COLOR).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)playerInfo)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + playerName.getString() + " ")));
        return playerName;
    }

    public static MutableComponent buildTeamHoverComponent(Team team) {
        MutableComponent playerName = Component.m_237113_((String)team.m_5758_());
        playerName.m_6270_(playerName.m_7383_().m_131140_(Messages.LINK_COLOR).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_264568_((String)"cli.msg.info.region.group.link.hover", (String)"Click to display team info"))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team list " + team.m_5758_())));
        return playerName;
    }

    public static MutableComponent buildRegionAreaDetailComponent(IMarkableRegion region) {
        IMarkableArea area = region.getArea();
        MutableComponent areaInfo = Component.m_237113_((String)area.getAreaType().areaType);
        switch (area.getAreaType()) {
            case CUBOID: {
                return Messages.substitutable("%s, %s", areaInfo, ChatComponentBuilder.buildCuboidAreaInfo((CuboidArea)area));
            }
            case SPHERE: {
                return Messages.substitutable("%s, %s", areaInfo, ChatComponentBuilder.buildSphereAreaInfo((SphereArea)area));
            }
        }
        throw new IllegalArgumentException("Invalid area type");
    }

    private static MutableComponent buildCuboidAreaInfo(CuboidArea cuboidArea) {
        return Component.m_264642_((String)"cli.msg.info.region.area.area.size.text.cuboid", (String)"Size: %s %s %s", (Object[])new Object[]{ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, Direction.Axis.X), ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, Direction.Axis.Y), ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, Direction.Axis.Z)});
    }

    private static MutableComponent buildSphereAreaInfo(SphereArea sphereArea) {
        int diameter = sphereArea.getRadius() * 2 + 1;
        MutableComponent centerPos = Component.m_237113_((String)ChatComponentBuilder.buildBlockPosLinkText(sphereArea.getCenterPos()));
        return Component.m_264642_((String)"cli.msg.info.region.area.area.size.text.sphere", (String)"Center: %s, Radius: %s, Diameter: %s", (Object[])new Object[]{ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(centerPos, centerPos, ChatFormatting.WHITE), sphereArea.getRadius(), diameter});
    }

    private static MutableComponent buildAreaAxisInfoComponent(CuboidArea cuboidArea, Direction.Axis axis) {
        BoundingBox area = cuboidArea.getArea();
        int axisSize = AreaUtil.blocksOnAxis(area, axis);
        String axisName = axis.m_122477_().toUpperCase();
        int min = axis.m_7863_(area.m_162395_(), area.m_162396_(), area.m_162398_());
        int max = axis.m_7863_(area.m_162399_(), area.m_162400_(), area.m_162401_());
        return ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(Component.m_237113_((String)(axisName + "=" + axisSize)), Component.m_237113_((String)(axisName + ": " + min + " - " + max)), ChatFormatting.WHITE);
    }

    public static MutableComponent buildTextWithHoverAndBracketsMsg(MutableComponent text, MutableComponent hoverText, ChatFormatting color) {
        MutableComponent bracketedText = ComponentUtils.m_130748_((Component)text);
        return ChatComponentBuilder.buildTextWithHoverMsg(bracketedText, hoverText, color);
    }

    public static MutableComponent buildTextWithWhiteBracketsAndHover(MutableComponent text, MutableComponent hoverText, ChatFormatting color) {
        return ComponentUtils.m_130748_((Component)ChatComponentBuilder.buildTextWithHoverMsg(text, hoverText, color));
    }

    public static MutableComponent buildTextWithHoverMsg(MutableComponent text, MutableComponent hoverText, ChatFormatting color) {
        text.m_6270_(text.m_7383_().m_131140_(color).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)));
        return text;
    }

    public static MutableComponent buildHelpStartComponent() {
        String command = Commands.buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.INFO.toString());
        MutableComponent text = Component.m_264568_((String)"help.hint.link.text", (String)"Start here");
        MutableComponent hover = Component.m_264642_((String)"help.hint.link.hover", (String)"Use '/%s global info' as a starting point to manage the global region", (Object[])new Object[]{"/yawp"});
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static List<String> getGroupsForRegion(IProtectedRegion region) {
        return Permissions.GROUP_LIST;
    }

    public static int getGroupSize(IProtectedRegion region, String groupName) {
        PlayerContainer group = region.getGroup(groupName);
        return group.getPlayers().size() + group.getTeams().size();
    }

    public static MutableComponent buildGroupListHeader(IProtectedRegion region, String group) {
        MutableComponent groupLink = ChatLinkBuilder.buildGroupLink(region, group, ChatComponentBuilder.getGroupSize(region, group));
        return ChatComponentBuilder.buildHeader(Component.m_264642_((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{groupLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static MutableComponent buildGroupTypeHeader(IProtectedRegion region, String group, GroupType groupType) {
        String fallback = "== Region '%s' " + groupType.name + " in %s ==";
        return Component.m_264642_((String)("cli.msg.info.region.group." + groupType.name + ".list"), (String)fallback, (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), group});
    }

    public static MutableComponent buildFlagStateComponent(IProtectedRegion region, IFlag flag) {
        FlagState state = flag.getState();
        MutableComponent text = Component.m_237113_((String)state.name);
        MutableComponent hover = Component.m_237119_();
        ChatFormatting color = ChatFormatting.WHITE;
        switch (state) {
            case ALLOWED: {
                color = ChatFormatting.GREEN;
                hover = Component.m_264568_((String)"cli.flag.state.allowed.info.hover", (String)"A flag with allowed state does not prevent the related action");
                break;
            }
            case DENIED: {
                color = ChatFormatting.RED;
                hover = Component.m_264568_((String)"cli.flag.state.denied.info.hover", (String)"A flag with denied state prevents the related action");
                break;
            }
            case DISABLED: {
                color = ChatFormatting.GRAY;
                hover = Component.m_264568_((String)"cli.flag.state.disabled.info.hover", (String)"A disabled flag is not considered in flag checks");
            }
        }
        MutableComponent stateInfo = ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(text, hover, color);
        return Messages.substitutable("%s %s", stateInfo, ChatLinkBuilder.buildFlagStateSuggestionLink(region, flag));
    }

    public static MutableComponent buildFlagMessageHoverText(IProtectedRegion region, IFlag flag) {
        MutableComponent flagMsgText = ChatComponentBuilder.truncateMsg(flag);
        MutableComponent hoverText = Component.m_237113_((String)flag.getFlagMsg().msg());
        if (flag.getFlagMsg().isDefault()) {
            String hoverFallback = "[{region}]: The '{flag}' flag denies this action here!";
            hoverText = Component.m_264568_((String)("flag.msg.deny." + region.getRegionType().type + ".default"), (String)hoverFallback);
        }
        return ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(flagMsgText, hoverText, ChatFormatting.WHITE);
    }

    public static MutableComponent truncateMsg(IFlag flag, int length) {
        Object flagMsg = flag.getFlagMsg().msg();
        if (flag.getFlagMsg().msg().length() > length) {
            flagMsg = ((String)flagMsg).substring(0, length) + "...";
        }
        return Component.m_237113_((String)flagMsg);
    }

    public static MutableComponent truncateMsg(IFlag flag) {
        return ChatComponentBuilder.truncateMsg(flag, 30);
    }

    public static MutableComponent buildFlagMessageComponent(IProtectedRegion region, IFlag flag) {
        MutableComponent editLink = ChatLinkBuilder.buildFlagMessageEditLink(region, flag);
        MutableComponent clearLink = ChatLinkBuilder.buildFlagMessageClearLink(region, flag);
        MutableComponent flagMsgTextWithHover = ChatComponentBuilder.buildFlagMessageHoverText(region, flag);
        return Messages.substitutable("%s %s '%s'", editLink, clearLink, flagMsgTextWithHover);
    }

    public static List<Component> buildRemoveRegionEntries(IProtectedRegion parent, List<IProtectedRegion> regions) {
        return regions.stream().map(region -> ChatComponentBuilder.buildRemoveRegionEntry(parent, region)).collect(Collectors.toList());
    }

    public static MutableComponent buildRemoveRegionEntry(IProtectedRegion parent, IProtectedRegion region) {
        return Messages.substitutable(" - %s", switch (parent.getRegionType()) {
            case RegionType.GLOBAL -> Messages.substitutable("%s %s", ChatComponentBuilder.buildDimResetComponent((DimensionalRegion)region), ChatLinkBuilder.buildRegionInfoLink(region));
            case RegionType.DIMENSION -> {
                MutableComponent childCompInfo = Component.m_264568_((String)"cli.msg.info.dim.region.child.hover", (String)"This is a direct child region of the Dimensional Region");
                MutableComponent childIndicator = ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(Component.m_237113_((String)"*"), childCompInfo, ChatFormatting.GOLD);
                MutableComponent regionInfoLinkWithIndicator = parent.hasChild(region) ? Messages.substitutable("%s%s", ChatLinkBuilder.buildRegionInfoLink(region), childIndicator) : Messages.substitutable("%s", ChatLinkBuilder.buildRegionInfoLink(region));
                MutableComponent removeLink = ChatLinkBuilder.buildDimSuggestRegionRemovalLink((IMarkableRegion)region);
                yield Messages.substitutable("%s %s", removeLink, regionInfoLinkWithIndicator);
            }
            case RegionType.LOCAL -> Messages.substitutable("%s %s", ChatLinkBuilder.buildRegionRemoveChildLink(parent, region), ChatLinkBuilder.buildRegionInfoLink(region));
            default -> throw new IllegalArgumentException();
        });
    }

    private static MutableComponent buildDimResetComponent(DimensionalRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().m_135782_().toString(), CommandConstants.RESET.toString(), CommandConstants.DIM.toString());
        MutableComponent hover = Component.m_264642_((String)"cli.dim.reset.dim.link.hover", (String)"Reset Dimensional Region '%s'", (Object[])new Object[]{region.getName()});
        MutableComponent text = Component.m_264568_((String)"cli.link.action.undo.text", (String)"<-");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static MutableComponent buildInfoComponent(String subjectLangKey, String fallback, MutableComponent payload) {
        return Messages.substitutable("%s: %s", Component.m_264568_((String)subjectLangKey, (String)fallback), payload);
    }

    public static MutableComponent buildInfoComponent(MutableComponent subject, MutableComponent info, MutableComponent actions) {
        return Messages.substitutable("%s: %s | %s", subject, info, actions);
    }

    public static MutableComponent buildInfoComponent(MutableComponent subject, MutableComponent content) {
        return Messages.substitutable("%s: %s", subject, content);
    }

    public static String buildExecuteCommandString(ResourceKey<Level> dim, String command) {
        return "/execute in " + String.valueOf(dim.m_135782_()) + " run " + command;
    }

    public static String buildTeleportCmd(ResourceKey<Level> dim, String tpSource, BlockPos target) {
        return ChatComponentBuilder.buildExecuteCommandString(dim, "tp " + tpSource + " " + ChatComponentBuilder.commandBlockPosStr(target));
    }

    public static List<Component> buildRemoveGroupMemberEntries(IProtectedRegion region, List<String> names, GroupType groupType, String group) {
        return names.stream().map(name -> ChatComponentBuilder.buildRemoveGroupEntry(region, name, groupType, group)).collect(Collectors.toList());
    }

    public static MutableComponent buildRemoveGroupEntry(IProtectedRegion region, String name, GroupType groupType, String group) {
        MutableComponent linkText = Component.m_264568_((String)"cli.link.remove", (String)"x");
        MutableComponent hoverText = Component.m_264642_((String)("cli.msg.info.region.group." + groupType.name + ".remove.link.hover"), (String)("Remove " + groupType.name + " '%s' from region %s"), (Object[])new Object[]{name, region.getName()});
        if (groupType == GroupType.PLAYER) {
            boolean isOffline;
            Player player = PlayerManager.getPlayer(name);
            boolean bl = isOffline = player == null;
            if (isOffline) {
                MutableComponent offlinePlayerRemoveLink = ChatLinkBuilder.buildRemoveLinkForOfflinePlayer(region, name, groupType, group, linkText, hoverText);
                return Messages.substitutable(" - %s %s", offlinePlayerRemoveLink, ChatComponentBuilder.buildGroupInfo(region, name, groupType));
            }
        }
        MutableComponent regionRemoveLink = ChatLinkBuilder.buildRemoveGroupMemberLink(region, name, groupType, group, linkText, hoverText);
        return Messages.substitutable(" - %s %s", regionRemoveLink, ChatComponentBuilder.buildGroupInfo(region, name, groupType));
    }

    public static MutableComponent buildGroupInfo(IProtectedRegion region, String groupMemberName, GroupType groupType) {
        return switch (groupType) {
            default -> throw new IncompatibleClassChangeError();
            case GroupType.PLAYER -> {
                Player player = PlayerManager.getPlayer(groupMemberName);
                if (player == null) {
                    yield Component.m_237110_((String)"%s %s", (Object[])new Object[]{Component.m_237113_((String)groupMemberName).m_130940_(ChatFormatting.GRAY), Component.m_264568_((String)"cli.msg.info.player.list.entry.offline", (String)"(offline)")});
                }
                yield ChatComponentBuilder.buildPlayerHoverComponent(player);
            }
            case GroupType.TEAM -> {
                Team team = PlayerManager.getTeam(groupMemberName);
                if (team == null) {
                    yield Component.m_237113_((String)groupMemberName);
                }
                yield ChatComponentBuilder.buildTeamHoverComponent(team);
            }
        };
    }

    public static List<String> getGroupList(IProtectedRegion region, String group, GroupType groupType) {
        switch (groupType) {
            case PLAYER: {
                return ChatComponentBuilder.getPlayerNamesByState(region, group);
            }
            case TEAM: {
                return region.getGroup(group).getTeams().stream().sorted().collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    @NotNull
    private static List<String> getPlayerNamesByState(IProtectedRegion region, String group) {
        ArrayList<String> names = new ArrayList<String>(region.getGroup(group).getPlayers().values());
        List<String> onlinePlayerNames = names.stream().map(name -> Map.entry(name, PlayerManager.getPlayer(name) != null)).filter(Map.Entry::getValue).map(Map.Entry::getKey).sorted().toList();
        names.removeAll(onlinePlayerNames);
        List offlinePlayers = names.stream().sorted().toList();
        ArrayList<String> playerNames = new ArrayList<String>(onlinePlayerNames);
        playerNames.addAll(offlinePlayers);
        return playerNames;
    }

    public static MutableComponent buildFlagInfoHeader(IProtectedRegion region, IFlag flag) {
        return ChatComponentBuilder.buildHeader(Component.m_264642_((String)"cli.msg.info.header.flag.in", (String)"== Flag %s in %s ==", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), ChatLinkBuilder.buildRegionInfoLink(region)}));
    }
}

