/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickException;
import de.z0rdak.yawp.util.StickType;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class StickUtil {
    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final ChatFormatting MARKED_BLOCK_COLOR = ChatFormatting.GREEN;
    private static final ChatFormatting UNMARKED_BLOCK_COLOR = ChatFormatting.RED;
    private static final ChatFormatting UNMARKED_POS_COLOR = ChatFormatting.AQUA;

    private StickUtil() {
    }

    public static void applyEnchantmentGlint(ItemStack item) {
        CompoundTag dummy = new CompoundTag();
        dummy.m_128359_("id", "");
        dummy.m_128405_("lvl", 1);
        ListTag enchantmentList = new ListTag();
        enchantmentList.add((Object)dummy);
        item.m_41700_("Enchantments", (Tag)enchantmentList);
    }

    public static void initStickTag(ItemStack stick, StickType type, ResourceKey<Level> dim) {
        CompoundTag itemTag;
        CompoundTag compoundTag = itemTag = stick.m_41782_() ? stick.m_41783_() : new CompoundTag();
        if (itemTag != null && Objects.requireNonNull(type) == StickType.MARKER) {
            CompoundTag compoundNBT = new MarkerStick(dim).serializeNBT();
            itemTag.m_128365_("stick", (Tag)compoundNBT);
            stick.m_41751_(itemTag);
        }
    }

    public static ItemStack initMarkerNbt(ItemStack stack, ResourceKey<Level> dim) {
        stack.m_41764_(1);
        StickUtil.initStickTag(stack, StickType.MARKER, dim);
        StickUtil.setStickName(stack, StickType.MARKER);
        StickUtil.setStickToolTip(stack, StickType.MARKER);
        StickUtil.applyEnchantmentGlint(stack);
        return stack;
    }

    public static boolean isVanillaStick(ItemStack itemStack) {
        return itemStack.m_41720_().m_7968_().m_41778_().equals(Items.f_42398_.m_5524_());
    }

    public static AbstractStick getStick(ItemStack stick) throws StickException {
        if (stick.m_41783_() != null && stick.m_41782_() && stick.m_41783_().m_128441_("stick")) {
            CompoundTag stickNbt = stick.m_41783_().m_128469_("stick");
            StickType type = StickType.of(stickNbt.m_128461_("stick_type"));
            switch (type) {
                case MARKER: {
                    return new MarkerStick(stickNbt);
                }
            }
            throw new StickException("Unknown stick type: '" + String.valueOf((Object)type) + "'!");
        }
        throw new StickException("Invalid or missing NBT data for Stick '" + stick.m_41611_().getString() + "'!");
    }

    public static StickType getStickType(ItemStack stick) {
        CompoundTag stickNbt;
        if (stick.m_41783_() != null && stick.m_41782_() && stick.m_41783_().m_128441_("stick") && (stickNbt = stick.m_41783_().m_128469_("stick")).m_128441_("stick_type")) {
            return StickType.of(stickNbt.m_128461_("stick_type"));
        }
        return StickType.UNKNOWN;
    }

    public static CompoundTag getStickNBT(ItemStack stick) {
        if (stick.m_41783_() != null && stick.m_41782_() && stick.m_41783_().m_128441_("stick")) {
            return stick.m_41783_().m_128469_("stick");
        }
        return null;
    }

    @Nullable
    public static IMarkableArea getMarkedArea(ItemStack stick) {
        CompoundTag stickNBT;
        if (StickUtil.isVanillaStick(stick) && StickUtil.isMarker(stick) && (stickNBT = StickUtil.getStickNBT(stick)) != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            if (!marker.isValidArea()) {
                return null;
            }
            return LocalRegions.areaFrom(marker);
        }
        return null;
    }

    public static boolean isMarker(ItemStack stick) {
        return StickUtil.getStickType(stick) == StickType.MARKER;
    }

    public static void setStickName(ItemStack stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            MarkerStick marker = new MarkerStick(StickUtil.getStickNBT(stick));
            MutableComponent markerIndicators = StickUtil.buildRegionMarkerIndicators(marker);
            MutableComponent markerHoverName = StickUtil.buildStickName(marker).m_130946_(" ").m_7220_((Component)markerIndicators);
            stick.m_41714_((Component)markerHoverName);
        }
    }

    private static MutableComponent buildStickName(MarkerStick marker) {
        MutableComponent stickName = Component.m_237113_((String)marker.getStickType().stickName).m_130940_(ChatFormatting.GOLD);
        MutableComponent areaType = Component.m_237113_((String)" (").m_130946_(marker.getAreaType().areaType).m_130946_(")");
        return stickName.m_7220_((Component)areaType);
    }

    private static MutableComponent buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        ChatFormatting color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        MutableComponent indicatorComp = Component.m_237113_((String)indicator).m_130940_(color);
        MutableComponent closedResetComp = Component.m_237113_((String)"]").m_130940_(ChatFormatting.RESET);
        return Component.m_237113_((String)"[").m_7220_((Component)indicatorComp).m_7220_((Component)closedResetComp);
    }

    private static MutableComponent buildRegionMarkerIndicators(MarkerStick marker) {
        int i;
        MutableComponent regionMarkerIndicators = Component.m_237113_((String)"");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (i = 0; i < marker.getMarkedBlocks().size(); ++i) {
            regionMarkerIndicators.m_7220_((Component)StickUtil.buildMarkerIndicator(true));
        }
        for (i = 0; i < amountUnmarked; ++i) {
            regionMarkerIndicators.m_7220_((Component)StickUtil.buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static void setStickToolTip(ItemStack stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            StickUtil.setToolTip(stick, StickUtil.getMarkerToolTip());
        }
    }

    public static void setToolTip(ItemStack stack, ListTag loreNbt) {
        stack.m_41698_("display").m_128365_("Lore", (Tag)loreNbt);
    }

    public static boolean hasNonNullTag(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_() != null;
    }

    private static ListTag getMarkerToolTip() {
        ListTag lore = new ListTag();
        lore.add((Object)StickUtil.buildLoreTextLine(Component.m_264568_((String)"help.tooltip.stick.marker.simple.1", (String)"Used to mark a new region."), "#ff4d4d"));
        lore.add((Object)StickUtil.buildLoreTextLine(Component.m_264568_((String)"help.tooltip.stick.marker.simple.2", (String)"Keep the Region Marker in your hand while creating a region!"), "#ff4d4d"));
        lore.add((Object)StickUtil.buildLoreTextLine(Component.m_237113_((String)String.valueOf(ChatFormatting.ITALIC)).m_7220_((Component)Component.m_264568_((String)"help.tooltip.stick.marker.simple.3", (String)"Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")), "#808080"));
        lore.add((Object)StickUtil.buildLoreTextLine(Component.m_237113_((String)String.valueOf(ChatFormatting.ITALIC)).m_7220_((Component)Component.m_264568_((String)"help.tooltip.stick.marker.simple.4", (String)"Set a region teleport position by shift-right-clicking a block.")), "#808080"));
        return lore;
    }

    private static StringTag buildLoreTextLine(String text, String hexColor) {
        return StringTag.m_129297_((String)("{\"text\":\"" + text + "\", \"color\":\"" + hexColor + "\"}"));
    }

    private static StringTag buildLoreTextLine(MutableComponent text, String hexColor) {
        return StickUtil.buildLoreTextLine(text.getString(), hexColor);
    }
}

