/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class AreaInfoMessage
implements MultiLineMessage<IMarkableArea> {
    private final IMarkableRegion region;
    private final IMarkableArea area;
    private final List<Component> regionInfoLines;

    public AreaInfoMessage(IMarkableRegion region) {
        this.region = region;
        this.area = region.getArea();
        this.regionInfoLines = new ArrayList<Component>();
    }

    @Override
    public IMarkableArea getContent() {
        return this.area;
    }

    @Override
    public List<Component> getLines() {
        this.regionInfoLines.clear();
        MutableComponent header = ChatComponentBuilder.buildHeader(Component.m_264642_((String)"cli.msg.info.header.of", (String)"== %s of %s ==", (Object[])new Object[]{ChatLinkBuilder.buildRegionAreaLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        MutableComponent area = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.area.area", "Area", ChatComponentBuilder.buildRegionAreaDetailComponent(this.region));
        MutableComponent blocks = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.area.marked", "Marked Blocks", ChatLinkBuilder.buildAreaMarkedBlocksTpLinks(this.region));
        MutableComponent display = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.display", "Display", ChatLinkBuilder.buildDisplaySettingsLink(this.region));
        MutableComponent actions = ChatComponentBuilder.buildInfoComponent("cli.msg.info.region.area.actions", "Actions", ChatLinkBuilder.buildRegionAreaActionLinks(this.region));
        this.regionInfoLines.add((Component)header);
        this.regionInfoLines.add((Component)area);
        this.regionInfoLines.add((Component)blocks);
        this.regionInfoLines.add((Component)display);
        this.regionInfoLines.add((Component)actions);
        return this.regionInfoLines;
    }
}

