/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public record FlagContext(IProtectedRegion region, RegionFlag regionFlag, @Nullable IFlag flag, @Nullable Player player) {
    public FlagState resultingState() {
        if (this.flag == null) {
            return FlagState.UNDEFINED;
        }
        boolean playerPerm = Permissions.playerHasBypassPermission(this.region, this.player);
        FlagState flagState = this.region.getFlags().flagState(this.regionFlag.name);
        if (!this.regionFlag.isPlayerFlag()) {
            return flagState;
        }
        if (this.regionFlag.isBeneficial()) {
            if (playerPerm) {
                return switch (flagState) {
                    case FlagState.ALLOWED, FlagState.DENIED -> FlagState.ALLOWED;
                    default -> FlagState.DISABLED;
                };
            }
            return flagState;
        }
        return playerPerm ? FlagState.DISABLED : flagState;
    }

    public FlagContext inheritContext(FlagContext parent) {
        boolean childFlagSet = this.region.getFlags().isSet(this.regionFlag.name);
        boolean parentFlagSet = parent.region.getFlags().isSet(this.regionFlag.name);
        boolean parentOverrides = parent.flag != null && parentFlagSet && parent.flag.doesOverride();
        boolean parentSetButNotChild = parentFlagSet && !childFlagSet;
        return parentOverrides || parentSetButNotChild ? parent : this;
    }

    public static FlagContext parentOf(IProtectedRegion region, RegionFlag regionFlag, @Nullable Player player) {
        IProtectedRegion parent = region.getParent();
        IFlag flag = parent.getFlag(regionFlag.name);
        return new FlagContext(parent, regionFlag, flag, player);
    }
}

