/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CommandInterceptor {
    private static final int CANCEL_CMD = 1;
    private static final int ALLOW_CMD = 0;

    public static int handleModCommands(ParseResults<CommandSourceStack> parseResults, String command) {
        CommandContextBuilder cmdContext = parseResults.getContext();
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        List cmdNodes = cmdContext.getNodes();
        List<String> nodeNames = cmdNodes.stream().map(node -> node.getNode().getName()).collect(Collectors.toList());
        try {
            CommandSourceType cmdSrcType = CommandSourceType.of(src);
            if (!CommandInterceptor.hasModBaseCmd(nodeNames)) {
                return 0;
            }
            if (nodeNames.size() > 2) {
                Constants.LOGGER.debug("Executed command: '{}' by '{}'.", (Object)command, (Object)((CommandSourceStack)cmdContext.getSource()).getTextName());
                String subCmd = nodeNames.get(1);
                int cancelExecutionResultCode = 0;
                switch (subCmd) {
                    case "local": {
                        if (!nodeNames.contains(CommandConstants.LOCAL.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.handleRegionCmdExecution((CommandContextBuilder<CommandSourceStack>)cmdContext, nodeNames, cmdSrcType);
                        break;
                    }
                    case "dim": {
                        if (!nodeNames.contains(CommandConstants.DIM.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.handleDimCommandExecution((CommandContextBuilder<CommandSourceStack>)cmdContext, cmdSrcType);
                        break;
                    }
                    case "global": {
                        if (!nodeNames.contains(CommandConstants.GLOBAL.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.verifyGlobalCommandPermission((CommandContextBuilder<CommandSourceStack>)cmdContext, cmdSrcType);
                        break;
                    }
                    case "flag": {
                        if (!nodeNames.contains(CommandConstants.FLAG.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.verifyFlagCommandPermission((CommandContextBuilder<CommandSourceStack>)cmdContext, nodeNames, cmdSrcType);
                        break;
                    }
                    case "marker": {
                        if (!nodeNames.contains(CommandConstants.MARKER.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.verifyMarkerCommandPermission((CommandContextBuilder<CommandSourceStack>)cmdContext, nodeNames, cmdSrcType);
                        break;
                    }
                    case "info": {
                        if (!nodeNames.contains(CommandConstants.INFO.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.handleShortcutCmdExecution((CommandContextBuilder<CommandSourceStack>)cmdContext, cmdSrcType);
                        break;
                    }
                    case "create": {
                        if (!nodeNames.contains(CommandConstants.CREATE.toString())) {
                            cancelExecutionResultCode = 1;
                            break;
                        }
                        cancelExecutionResultCode = CommandInterceptor.handleCreateShortcutCmdExecution((CommandContextBuilder<CommandSourceStack>)cmdContext, nodeNames, cmdSrcType);
                        break;
                    }
                    case "delete": {
                        cancelExecutionResultCode = !nodeNames.contains(CommandConstants.DELETE.toString()) ? 1 : CommandInterceptor.handleShortcutCmdExecution((CommandContextBuilder<CommandSourceStack>)cmdContext, cmdSrcType);
                    }
                }
                return cancelExecutionResultCode;
            }
        }
        catch (RuntimeException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
        return 0;
    }

    private static int handleShortcutCmdExecution(CommandContextBuilder<CommandSourceStack> cmdContext, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        IProtectedRegion region = CommandInterceptor.checkValidLocalRegionShortcut(cmdContext, CommandConstants.LOCAL);
        if (region == null) {
            return 1;
        }
        try {
            boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region);
            CommandInterceptor.handlePermission(src, region, hasPermission);
            return hasPermission ? 0 : 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static int handleCreateShortcutCmdExecution(CommandContextBuilder<CommandSourceStack> cmdContext, List<String> nodeNames, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        Optional<IDimensionRegionApi> maybeDimApi = RegionManager.get().getDimRegionApi((ResourceKey<Level>)src.getLevel().dimension());
        if (maybeDimApi.isEmpty()) {
            return 1;
        }
        try {
            IDimensionRegionApi dimApi = maybeDimApi.get();
            DimensionalRegion region = dimApi.getCache().getDim();
            boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region);
            CommandInterceptor.handlePermission(src, region, hasPermission);
            return hasPermission ? 0 : 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static int verifyMarkerCommandPermission(CommandContextBuilder<CommandSourceStack> cmdContext, List<String> nodeNames, CommandSourceType cmdSrcType) {
        try {
            boolean isMarkerSubCmd = CommandInterceptor.checkSubCmdAtIndex(nodeNames, 2, CommandConstants.RESET, CommandConstants.GIVE, CommandConstants.CREATE);
            if (!isMarkerSubCmd) {
                return 0;
            }
            if (cmdSrcType == CommandSourceType.PLAYER) {
                boolean isCreateCmd = CommandInterceptor.checkSubCmdAtIndex(nodeNames, 2, CommandConstants.CREATE, new CommandConstants[0]);
                boolean isParentArgProvided = nodeNames.size() >= 5 && nodeNames.get(4) != null;
                ServerPlayer player = ((CommandSourceStack)cmdContext.getSource()).getPlayerOrException();
                LevelRegionData dimCache = RegionDataManager.getOrCreate((ResourceKey<Level>)player.level().dimension());
                boolean hasPermission = Services.PERMISSION_CONFIG.hasConfigPermission((CommandSourceStack)cmdContext.getSource(), cmdSrcType);
                boolean hasRegionPermission = false;
                if (isCreateCmd) {
                    if (isParentArgProvided) {
                        String parentName;
                        IMarkableRegion parent;
                        ParsedArgument commandSourceParsedArgument = (ParsedArgument)cmdContext.getArguments().get(nodeNames.get(4));
                        Object object = commandSourceParsedArgument.getResult();
                        if (object instanceof String && (parent = dimCache.getLocal(parentName = (String)object)) != null) {
                            hasRegionPermission = Permissions.get().hasGroupPermission(parent, (Player)player, "owners");
                        }
                    } else {
                        hasRegionPermission = Permissions.get().hasGroupPermission(dimCache.getDim(), (Player)player, "owners");
                    }
                } else {
                    hasRegionPermission = Permissions.get().hasGroupPermission(dimCache.getDim(), (Player)player, "owners");
                }
                hasPermission = hasPermission || hasRegionPermission;
                CommandInterceptor.handlePermission((CommandSourceStack)cmdContext.getSource(), hasPermission);
                return hasPermission ? 0 : 1;
            }
            Constants.LOGGER.error("A player is required to execute this command.");
            return 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static int verifyFlagCommandPermission(CommandContextBuilder<CommandSourceStack> cmdContext, List<String> nodeNames, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        try {
            String regionTypeCmd;
            boolean isRegionTypeCmd = CommandInterceptor.checkSubCmdAtIndex(nodeNames, 2, CommandConstants.LOCAL, CommandConstants.DIM, CommandConstants.GLOBAL);
            if (!isRegionTypeCmd) {
                return 0;
            }
            switch (regionTypeCmd = nodeNames.get(2)) {
                case "local": {
                    IProtectedRegion region = CommandInterceptor.checkValidLocalRegion(cmdContext);
                    if (region == null) {
                        return 0;
                    }
                    Function<List<String>, Boolean> subCmdPermission = nodes -> {
                        int subCmdIdx = 6;
                        boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, new CommandConstants[0]);
                        boolean isFlagShortCmd = nodes.size() == subCmdIdx;
                        return (isFlagShortCmd || isReadOnlyCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
                    };
                    boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
                    CommandInterceptor.handlePermission(src, region, hasPermission);
                    return hasPermission ? 0 : 1;
                }
                case "dim": {
                    LevelRegionData dimCache = CommandInterceptor.checkValidDimRegion(cmdContext);
                    if (dimCache == null) {
                        return 0;
                    }
                    DimensionalRegion region = dimCache.getDim();
                    Function<List<String>, Boolean> subCmdPermission = nodes -> {
                        int subCmdIdx = 5;
                        boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, new CommandConstants[0]);
                        boolean isFlagShortCmd = nodes.size() == subCmdIdx;
                        return (isFlagShortCmd || isReadOnlyCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
                    };
                    boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
                    CommandInterceptor.handlePermission(src, region, hasPermission);
                    return hasPermission ? 0 : 1;
                }
                case "global": {
                    GlobalRegion region = RegionManager.get().getGlobalRegion();
                    Function<List<String>, Boolean> subCmdPermission = nodes -> {
                        int subCmdIdx = 4;
                        boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, new CommandConstants[0]);
                        boolean isFlagShortCmd = nodes.size() == subCmdIdx;
                        return (isFlagShortCmd || isReadOnlyCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
                    };
                    boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
                    CommandInterceptor.handlePermission(src, region, hasPermission);
                    return hasPermission ? 0 : 1;
                }
            }
            return 0;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static int verifyGlobalCommandPermission(CommandContextBuilder<CommandSourceStack> cmdContext, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        GlobalRegion region = RegionManager.get().getGlobalRegion();
        try {
            Function<List<String>, Boolean> subCmdPermission = nodes -> {
                int subCmdIdx = 2;
                boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, CommandConstants.LIST);
                boolean isExtendedInfoCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.STATE, new CommandConstants[0]) && nodes.size() == subCmdIdx + 1;
                boolean isRegionShortCmd = nodes.size() == subCmdIdx;
                return (isRegionShortCmd || isReadOnlyCmd || isExtendedInfoCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
            };
            boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
            CommandInterceptor.handlePermission(src, region, hasPermission);
            return hasPermission ? 0 : 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int handleRegionCmdExecution(CommandContextBuilder<CommandSourceStack> cmdContext, List<String> nodeNames, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        IProtectedRegion region = CommandInterceptor.checkValidLocalRegion(cmdContext);
        if (region == null) {
            return 1;
        }
        try {
            int subCmdIndex = nodeNames.indexOf(CommandConstants.AREA.toString());
            subCmdIndex = 4;
            Function<List<String>, Boolean> subCmdPermission = nodes -> {
                int subCmdIdx = nodes.indexOf(CommandConstants.AREA.toString());
                subCmdIdx = 4;
                boolean isAreaWriteCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.AREA, new CommandConstants[0]) && nodes.size() > subCmdIdx + 1;
                boolean isRegionTpCmd = isAreaWriteCmd && CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx + 1, CommandConstants.TELEPORT, new CommandConstants[0]) && nodes.size() >= subCmdIdx + 2;
                boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, CommandConstants.LIST);
                boolean isExtendedInfoCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.STATE, CommandConstants.AREA) && nodes.size() == subCmdIdx + 1;
                boolean isRegionShortCmd = nodes.size() == subCmdIdx;
                boolean isReadOnlyAndAllowed = (isRegionShortCmd || isReadOnlyCmd || isExtendedInfoCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
                boolean isRegionTpAndAllowed = isRegionTpCmd && Services.PERMISSION_CONFIG.allowRegionTp();
                return isReadOnlyAndAllowed || isRegionTpAndAllowed;
            };
            boolean isAreaWriteCmd = CommandInterceptor.checkSubCmdAtIndex(nodeNames, subCmdIndex, CommandConstants.AREA, new CommandConstants[0]) && nodeNames.size() > subCmdIndex + 1;
            boolean isAreaSetCmd = isAreaWriteCmd && CommandInterceptor.checkSubCmdAtIndex(nodeNames, subCmdIndex + 1, CommandConstants.SET, new CommandConstants[0]) && nodeNames.size() > subCmdIndex + 2;
            boolean isAreaExpandCmd = isAreaWriteCmd && CommandInterceptor.checkSubCmdAtIndex(nodeNames, subCmdIndex + 1, CommandConstants.EXPAND, new CommandConstants[0]) && nodeNames.size() > subCmdIndex + 2;
            boolean isAreaModifyCmd = isAreaWriteCmd && (isAreaExpandCmd || isAreaSetCmd);
            boolean hasParentPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region.getParent());
            if (isAreaModifyCmd && !hasParentPermission) {
                CommandInterceptor.handlePermission(src, region.getParent(), false);
                return 1;
            }
            boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
            CommandInterceptor.handlePermission(src, region, hasPermission);
            return hasPermission ? 0 : 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    public static int handleDimCommandExecution(CommandContextBuilder<CommandSourceStack> cmdContext, CommandSourceType cmdSrcType) {
        CommandSourceStack src = (CommandSourceStack)cmdContext.getSource();
        LevelRegionData dimCache = CommandInterceptor.checkValidDimRegion(cmdContext);
        if (dimCache == null) {
            return 1;
        }
        try {
            DimensionalRegion region = dimCache.getDim();
            Function<List<String>, Boolean> subCmdPermission = nodes -> {
                int subCmdIdx = 3;
                boolean isReadOnlyCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.INFO, CommandConstants.LIST);
                boolean isExtendedInfoCmd = CommandInterceptor.checkSubCmdAtIndex(nodes, subCmdIdx, CommandConstants.STATE, new CommandConstants[0]) && nodes.size() == subCmdIdx + 1;
                boolean isRegionShortCmd = nodes.size() == subCmdIdx;
                return (isRegionShortCmd || isReadOnlyCmd || isExtendedInfoCmd) && Services.PERMISSION_CONFIG.isReadOnlyAllowed();
            };
            boolean hasPermission = CommandInterceptor.hasCmdPermission(cmdContext, cmdSrcType, "owners", region, subCmdPermission);
            CommandInterceptor.handlePermission(src, region, hasPermission);
            return hasPermission ? 0 : 1;
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            return 1;
        }
    }

    private static boolean hasModBaseCmd(List<String> nodeNames) {
        return !nodeNames.isEmpty() && nodeNames.get(0) != null && nodeNames.get(0).equals("yawp");
    }

    @Nullable
    private static LevelRegionData checkValidDimRegion(CommandContextBuilder<CommandSourceStack> cmdContext) {
        Object object;
        ParsedArgument dimParsedArgument = (ParsedArgument)cmdContext.getArguments().get(CommandConstants.DIM.toString());
        if (dimParsedArgument != null && (object = dimParsedArgument.getResult()) instanceof ResourceLocation) {
            ResourceLocation dimResLoc = (ResourceLocation)object;
            ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimResLoc);
            Optional<LevelRegionData> levelData = RegionManager.get().getLevelRegionData((ResourceKey<Level>)dim);
            if (levelData.isEmpty()) {
                MessageSender.sendCmdFeedback((CommandSourceStack)cmdContext.getSource(), Component.literal((String)"Dimension not found in region data").withStyle(ChatFormatting.RED));
                return null;
            }
            return levelData.get();
        }
        return null;
    }

    @Nullable
    private static IProtectedRegion checkValidLocalRegionShortcut(CommandContextBuilder<CommandSourceStack> cmdContext, CommandConstants argumentKey) {
        Object object;
        ParsedArgument regionArg = (ParsedArgument)cmdContext.getArguments().get(argumentKey.toString());
        if (regionArg != null && (object = regionArg.getResult()) instanceof String) {
            String regionName = (String)object;
            ServerLevel level = ((CommandSourceStack)cmdContext.getSource()).getLevel();
            LevelRegionData dimCache = RegionDataManager.getOrCreate((ResourceKey<Level>)level.dimension());
            if (!dimCache.hasLocal(regionName)) {
                MessageSender.sendCmdFeedback((CommandSourceStack)cmdContext.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                return null;
            }
            IMarkableRegion region = dimCache.getLocal(regionName);
            if (region == null) {
                MessageSender.sendCmdFeedback((CommandSourceStack)cmdContext.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                return null;
            }
            return region;
        }
        return null;
    }

    @Nullable
    private static IProtectedRegion checkValidLocalRegion(CommandContextBuilder<CommandSourceStack> cmdContext) {
        Object object;
        ParsedArgument regionArg = (ParsedArgument)cmdContext.getArguments().get(CommandConstants.LOCAL.toString());
        if (regionArg != null && (object = regionArg.getResult()) instanceof String) {
            Object object2;
            String regionName = (String)object;
            ParsedArgument dimParsedArgument = (ParsedArgument)cmdContext.getArguments().get(CommandConstants.DIM.toString());
            if (dimParsedArgument != null && (object2 = dimParsedArgument.getResult()) instanceof ResourceLocation) {
                ResourceLocation dimResLoc = (ResourceLocation)object2;
                ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimResLoc);
                LevelRegionData dimCache = RegionDataManager.getOrCreate((ResourceKey<Level>)dim);
                if (!dimCache.hasLocal(regionName)) {
                    MessageSender.sendCmdFeedback((CommandSourceStack)cmdContext.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                    return null;
                }
                IMarkableRegion region = dimCache.getLocal(regionName);
                if (region == null) {
                    MessageSender.sendCmdFeedback((CommandSourceStack)cmdContext.getSource(), Component.literal((String)("No region with name '" + regionName + "' defined in dim '" + dimCache.getDim().getName() + "'")));
                    return null;
                }
                return region;
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkSubCmdAtIndex(List<String> nodeNames, int index, CommandConstants subCmd, CommandConstants ... subCmds) {
        List subCmdList = Arrays.stream(subCmds).map(CommandConstants::toString).collect(Collectors.toList());
        subCmdList.add(subCmd.toString());
        if (nodeNames.size() < index + 1) return false;
        if (nodeNames.get(index) == null) return false;
        if (!subCmdList.stream().anyMatch(nodeNames.get(index)::equals)) return false;
        return true;
    }

    private static void handlePermission(CommandSourceStack src, IProtectedRegion region, boolean hasPermission) {
        if (!hasPermission) {
            Constants.LOGGER.info("'{}' is not allowed to manage region '{}'", (Object)src.getTextName(), (Object)region.getName());
            MessageSender.sendCmdFeedback(src, Component.translatableWithFallback((String)"cli.msg.info.region.modify.deny", (String)"[%s] You don't have the permission to execute this command!", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
        }
    }

    private static void handlePermission(CommandSourceStack src, boolean hasPermission) {
        if (!hasPermission) {
            Constants.LOGGER.info("'{}' is not allowed to execute this command", (Object)src.getTextName());
            MessageSender.sendCmdFeedback(src, Component.translatableWithFallback((String)"cli.msg.info.cmd.deny", (String)"You don't have permission to execute this command!"));
        }
    }

    private static boolean hasCmdPermission(CommandContextBuilder<CommandSourceStack> ctx, CommandSourceType cmdSrcType, String permissionGroup, IProtectedRegion region) throws CommandSyntaxException {
        switch (cmdSrcType) {
            case PLAYER: {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                boolean hasConfigPermission = Permissions.get().hasConfigPermission((Player)player);
                boolean hasRegionPermission = Permissions.get().hasGroupPermission(region, (Player)player, permissionGroup);
                return hasRegionPermission || hasConfigPermission;
            }
            case SERVER: {
                return true;
            }
            case COMMAND_BLOCK: {
                return Services.PERMISSION_CONFIG.isCommandBlockExecutionAllowed();
            }
        }
        return false;
    }

    private static boolean hasCmdPermission(CommandContextBuilder<CommandSourceStack> ctx, CommandSourceType cmdSrcType, String permissionGroup, IProtectedRegion region, Function<List<String>, Boolean> subCmdPermission) throws CommandSyntaxException {
        switch (cmdSrcType) {
            case PLAYER: {
                List nodeNames = ctx.getNodes().stream().map(node -> node.getNode().getName()).collect(Collectors.toList());
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                boolean hasConfigPermission = Permissions.get().hasConfigPermission((Player)player);
                boolean hasRegionPermission = Permissions.get().hasGroupPermission(region, (Player)player, permissionGroup);
                boolean hasSubCmdPermission = subCmdPermission.apply(nodeNames);
                return hasRegionPermission || hasConfigPermission || hasSubCmdPermission;
            }
            case SERVER: {
                return true;
            }
            case COMMAND_BLOCK: {
                return Services.PERMISSION_CONFIG.isCommandBlockExecutionAllowed();
            }
        }
        return false;
    }
}

