/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.permission;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Permissions {
    public static final String MEMBER = "members";
    public static final String OWNER = "owners";
    public static final List<String> GROUP_LIST = Arrays.asList("members", "owners");
    private static final Permissions permission = new Permissions();

    private Permissions() {
    }

    public static Permissions get() {
        return permission;
    }

    public static List<String> getGroups(IProtectedRegion region, Player player) {
        return GROUP_LIST;
    }

    public static boolean playerHasBypassPermission(@NotNull IProtectedRegion region, @Nullable Player player) {
        return player != null && Permissions.hasPermissionOrIsOpWithBypass(region, player);
    }

    private static boolean hasPermissionOrIsOpWithBypass(@NotNull IProtectedRegion region, @NotNull Player player) {
        boolean hasPermission = permission.hasAnyPermission(region, player, Permissions.getGroups(region, player));
        return hasPermission || permission.hasConfigPermAndOpBypassFlags(player);
    }

    public boolean hasConfigPermAndOpBypassFlags(Player player) {
        boolean byPassFlagAllowed = PermissionConfig.byPassFlagAllowed();
        boolean hasConfigPerm = PermissionConfig.hasConfigPermission(player);
        return hasConfigPerm && byPassFlagAllowed;
    }

    public boolean hasConfigPermission(CommandSourceStack src, CommandSourceType srcType) throws CommandSyntaxException {
        return PermissionConfig.hasConfigPermission(src, srcType);
    }

    public boolean hasConfigPermission(Player player) {
        return PermissionConfig.hasConfigPermission(player);
    }

    public boolean hasOwnerPermission(IProtectedRegion region, Player player) {
        return this.hasGroupPermission(region, player, OWNER);
    }

    public boolean hasAnyPermission(IProtectedRegion region, Player player, List<String> groups) {
        return groups.stream().map(group -> this.hasGroupPermission(region, player, (String)group)).reduce(false, (b1, b2) -> b1 != false || b2 != false);
    }

    public boolean hasCmdPermission(CommandSourceStack src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            return PermissionConfig.hasConfigPermission(src, cmdSrcType);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean isAllowedForNonOp(CommandSourceStack src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            boolean hasConfigPerm = PermissionConfig.hasConfigPermission(src, cmdSrcType);
            return hasConfigPerm || PermissionConfig.isCmdEnabledForNonOp();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean hasGroupPermission(IProtectedRegion region, Player player, String permissionGroup) {
        return PermissionConfig.isHierarchyOwnershipEnabled() ? this.hasRegionHierarchyPermission(region, player, permissionGroup) : this.isInGroup(region, player, permissionGroup);
    }

    public boolean isInGroup(IProtectedRegion region, Player player, String group) {
        return region.isInGroup(player, group);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, Player player, String permissionGroup) {
        return this.hasRegionHierarchyPermission(region, player, permissionGroup, false);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, Player player, String permissionGroup, boolean hasPermission) {
        if (region.getParent().equals(region)) {
            return hasPermission || this.isInGroup(region, player, permissionGroup);
        }
        hasPermission = hasPermission || this.isInGroup(region, player, permissionGroup);
        return this.hasRegionHierarchyPermission(region.getParent(), player, permissionGroup, hasPermission);
    }
}

