/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public final class VisualizationUtil {
    private VisualizationUtil() {
    }

    public static void updateDisplayBlock(Entity blockDisplayEntity, ResourceLocation blockRl) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        CompoundTag blockState = entityTag.getCompound("block_state");
        blockState.putString("Name", blockRl.toString());
        entityTag.put("block_state", (Tag)blockState);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(Entity blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        entityTag.putBoolean("Glowing", glow);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(Entity blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", lightLevel);
        brightnessTag.putInt("block", lightLevel);
        entityTag.put("brightness", (Tag)brightnessTag);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(Entity blockDisplayEntity, BlockDisplayProperties properties) {
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        CompoundTag blockState = entityTag.getCompound("block_state");
        blockState.putString("Name", properties.blockRl().toString());
        entityTag.put("block_state", (Tag)blockState);
        entityTag.putBoolean("Glowing", properties.hasGlow());
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", properties.lightLevel());
        brightnessTag.putInt("block", properties.lightLevel());
        entityTag.put("brightness", (Tag)brightnessTag);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static Entity createBlockDisplayRecursive(ServerLevel level, BlockPos pos, CompoundTag displayTag) {
        return EntityType.loadEntityRecursive((CompoundTag)displayTag, (Level)level, p_396566_ -> {
            p_396566_.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), p_396566_.getYRot(), p_396566_.getXRot());
            return p_396566_;
        });
    }

    public static Optional<Entity> createDisplayEntity(ServerLevel level, BlockPos pos, CompoundTag displayTag) {
        Optional entity = EntityType.create((CompoundTag)displayTag, (Level)level);
        entity.ifPresent(e -> e.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), e.yRotO, e.xRotO));
        return entity;
    }

    public static Optional<Entity> createTextDisplayEntity(ServerLevel level, String regionName, BlockPos pos, TextDisplayProperties displayProperties) {
        CompoundTag entityTag = VisualizationUtil.buildTeleportAnchorTextDisplayTag(regionName, displayProperties);
        Optional maybeEntity = EntityType.create((CompoundTag)entityTag, (Level)level);
        maybeEntity.ifPresent(e -> e.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), e.yRotO, e.xRotO));
        return maybeEntity;
    }

    public static Optional<Entity> createBlockDisplayEntity(ServerLevel level, String regionName, BlockPos pos, BlockDisplayProperties displayProperties) {
        CompoundTag entityTag = VisualizationUtil.buildBlockDisplayTag(regionName, displayProperties);
        Optional maybeEntity = EntityType.create((CompoundTag)entityTag, (Level)level);
        maybeEntity.ifPresent(e -> e.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), e.yRotO, e.xRotO));
        return maybeEntity;
    }

    public static CompoundTag buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        CompoundTag textDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.withDefaultNamespace((String)"text_display");
        textDisplayTag.putString("id", blockDisplayRl.toString());
        CompoundTag data = new CompoundTag();
        data.putString("yawp_display", "text");
        data.putString("region", regionName);
        data.putString("tpAnchor", properties.getText());
        textDisplayTag.put("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", 15);
        brightnessTag.putInt("block", 15);
        textDisplayTag.put("brightness", (Tag)brightnessTag);
        textDisplayTag.putString("billboard", "center");
        MutableComponent text = Component.literal((String)properties.toString());
        textDisplayTag.putString("text", text.toString());
        textDisplayTag.putString("alignment", "center");
        textDisplayTag.putInt("background", 0x1A000000);
        return textDisplayTag;
    }

    public static CompoundTag buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        CompoundTag blockDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.withDefaultNamespace((String)"block_display");
        blockDisplayTag.putString("id", blockDisplayRl.getPath());
        blockDisplayTag.putBoolean("Glowing", properties.hasGlow());
        CompoundTag data = new CompoundTag();
        data.putString("yawp_display", "block");
        data.putString("region", regionName);
        blockDisplayTag.put("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", properties.lightLevel());
        brightnessTag.putInt("block", properties.lightLevel());
        blockDisplayTag.put("brightness", (Tag)brightnessTag);
        CompoundTag blockstateTag = new CompoundTag();
        blockstateTag.putString("Name", properties.blockRl().toString());
        blockDisplayTag.put("block_state", (Tag)blockstateTag);
        return blockDisplayTag;
    }
}

