/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FlagState {
    DISABLED("Disabled"),
    ALLOWED("Allowed"),
    DENIED("Denied"),
    UNDEFINED("Undefined");

    public final String name;

    private FlagState(String name) {
        this.name = name;
    }

    public static FlagState from(boolean value) {
        return value ? ALLOWED : DENIED;
    }

    public static FlagState from(String value) throws IllegalArgumentException {
        switch (value.toLowerCase()) {
            case "allowed": {
                return ALLOWED;
            }
            case "denied": {
                return DENIED;
            }
            case "disabled": {
                return DISABLED;
            }
            case "undefined": {
                return UNDEFINED;
            }
        }
        throw new IllegalArgumentException("Unknown flag state: " + value);
    }

    public static List<String> ValidFlagStates() {
        return Arrays.stream(FlagState.values()).filter(state -> state != UNDEFINED).map(fs -> fs.name).collect(Collectors.toList());
    }

    public static boolean validLoggingStates(String flagState) {
        return Stream.of(ALLOWED, DENIED).anyMatch(state -> state.name.equalsIgnoreCase(flagState));
    }

    public static FlagState invert(FlagState state) {
        switch (state.ordinal()) {
            case 1: {
                return DENIED;
            }
            case 2: {
                return ALLOWED;
            }
        }
        return state;
    }
}

