/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedAreaTypes;
import de.z0rdak.yawp.core.area.RegionAnchors;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.flag.FlagValue;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlags;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.CuboidRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.ProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.core.region.SphereRegion;
import de.z0rdak.yawp.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class MarkedRegion
extends ProtectedRegion
implements IMarkableRegion {
    public static final Codec<IMarkableRegion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(IProtectedRegion::getName), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(IProtectedRegion::getDim), (App)Codec.STRING.fieldOf("parentName").forGetter(IProtectedRegion::getParentName), (App)Codec.STRING.fieldOf("type").forGetter(r -> r.getRegionType().type), (App)Codec.unboundedMap((Codec)Codec.STRING, FlagValue.CODEC).optionalFieldOf("flags", Lifecycle.stable(), new HashMap(), Lifecycle.stable()).forGetter(r -> r.getFlags().getFlagMap()), (App)Codec.BOOL.optionalFieldOf("isActive", (Object)true).forGetter(IProtectedRegion::isActive), (App)Codec.BOOL.optionalFieldOf("isMuted", (Object)false).forGetter(IProtectedRegion::isMuted), (App)Codec.INT.fieldOf("priority").forGetter(IMarkableRegion::getPriority), (App)Codec.STRING.fieldOf("areaType").forGetter(r -> MarkedAreaTypes.areaIdentifier(r.getAreaType()).toString()), (App)MarkedAreaTypes.MARKED_AREA_CODEC.fieldOf("area").forGetter(IMarkableRegion::getArea), (App)Codec.unboundedMap((Codec)Codec.STRING, TeleportAnchor.CODEC).optionalFieldOf("tpAnchors", Lifecycle.stable(), new HashMap(), Lifecycle.stable()).forGetter(r -> r.getTpAnchors().getTpAnchors()), (App)Codec.unboundedMap((Codec)Codec.STRING, PlayerContainer.CODEC).optionalFieldOf("groups", Lifecycle.stable(), new HashMap(), Lifecycle.stable()).forGetter(IProtectedRegion::getGroups), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("childrenNames", Lifecycle.stable(), new ArrayList(), Lifecycle.stable()).forGetter(r -> new ArrayList<String>(r.getChildrenNames()))).apply((Applicative)instance, (name, dim, parentName, regionType, flags, isActive, isMuted, priority, areaType, area, anchors, groups, childrenNames) -> {
        String lowerCase = areaType.toLowerCase(Locale.ROOT);
        ResourceLocation rl = ResourceLocation.tryParse((String)lowerCase);
        if (rl == null) {
            throw new IllegalStateException("Unexpected value: " + lowerCase);
        }
        AreaType areaT = AreaType.of(rl.getPath());
        switch (areaT) {
            case CUBOID: {
                return new CuboidRegion((String)name, (ResourceKey<Level>)dim, (String)parentName, (Map<String, IFlag>)flags, (boolean)isActive, (boolean)isMuted, (int)priority, (IMarkableArea)area, new RegionAnchors((Map<String, TeleportAnchor>)anchors), (Map<String, PlayerContainer>)groups, (List<String>)childrenNames);
            }
            case SPHERE: {
                return new SphereRegion((String)name, (ResourceKey<Level>)dim, (String)parentName, (Map<String, IFlag>)flags, (boolean)isActive, (boolean)isMuted, (int)priority, (IMarkableArea)area, new RegionAnchors((Map<String, TeleportAnchor>)anchors), (Map<String, PlayerContainer>)groups, (List<String>)childrenNames);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)areaT));
    }));
    protected int priority;
    protected IMarkableArea area;
    protected AreaType areaType;
    protected RegionAnchors anchors;

    protected MarkedRegion(String name, ResourceKey<Level> dim, String parentName, Map<String, IFlag> flags, boolean isActive, boolean isMuted, int priority, String areaType, IMarkableArea area, RegionAnchors anchors, Map<String, PlayerContainer> groups, List<String> childrenNames) {
        super(name, dim, RegionType.LOCAL, null);
        this.setArea(area);
        this.setPriority(priority);
        this.areaType = AreaType.of(areaType);
        this.parentName = parentName;
        this.anchors = anchors;
        this.setFlags(new RegionFlags(flags));
        this.setIsActive(isActive);
        this.setIsMuted(isMuted);
        this.setGroups(groups);
        this.setChildrenNames(childrenNames);
    }

    public MarkedRegion(String name, IMarkableArea area, Player owner, ResourceKey<Level> dimension, ProtectedRegion parent) {
        super(name, dimension, RegionType.LOCAL, owner);
        this.area = area;
        this.areaType = area.getAreaType();
        this.priority = Services.REGION_CONFIG.getDefaultPriority();
        this.anchors = new RegionAnchors();
        if (parent != null) {
            this.setParent(parent);
        }
    }

    public MarkedRegion(String name, IMarkableArea area, Player owner, ResourceKey<Level> dimension) {
        this(name, area, owner, dimension, null);
    }

    public MarkedRegion(String name, IMarkableArea area, RegionAnchors anchors, Player owner, ResourceKey<Level> dimension) {
        this(name, area, owner, dimension, null);
        this.anchors = anchors;
    }

    @Override
    protected boolean setParent(IProtectedRegion parent) {
        if (this.parent == null) {
            boolean isParentLocalOrDim = parent.getRegionType() == RegionType.DIMENSION || parent.getRegionType() == RegionType.LOCAL;
            return isParentLocalOrDim && super.setParent(parent);
        }
        if (this.parent.getRegionType() == RegionType.LOCAL && parent.getRegionType() == RegionType.DIMENSION) {
            return super.setParent(parent);
        }
        if (this.parent.getRegionType() == RegionType.DIMENSION && parent.getRegionType() == RegionType.LOCAL) {
            return super.setParent(parent);
        }
        return false;
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        if (child.getRegionType() == RegionType.LOCAL && child.getParent() == null) {
            return super.addChild(child);
        }
        if (child.getRegionType() == RegionType.LOCAL && child.getParent().getRegionType() == RegionType.DIMENSION) {
            return super.addChild(child);
        }
        return false;
    }

    @Override
    public boolean contains(BlockPos position) {
        return this.area.contains(position);
    }

    @Override
    public IMarkableArea getArea() {
        return this.area;
    }

    @Override
    public void setArea(IMarkableArea area) {
        this.area = area;
        this.areaType = area.getAreaType();
    }

    @Override
    public void rename(String newName) {
        this.setName(newName);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public AreaType getAreaType() {
        return this.areaType;
    }

    @Override
    public RegionAnchors getTpAnchors() {
        return this.anchors;
    }
}

