/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.util.StickUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class MarkerStickHandler {
    public static void onCreateStick(Player player, ItemStack input, ItemStack output) {
        input.setCount(output.getCount() - 1);
        player.addItem(input);
        player.giveExperienceLevels(1);
        StickUtil.initMarkerNbt(output, (ResourceKey<Level>)player.level().dimension());
    }

    public static void onMarkBlock(Player player, ItemStack involvedItem, BlockPos target) {
        if (HandlerUtil.isServerSide(player.level()) && !involvedItem.equals(ItemStack.EMPTY) && StickUtil.isMarker(involvedItem)) {
            MarkerStick marker = new MarkerStick(StickUtil.getStickNBT(involvedItem));
            AreaType areaType = marker.getAreaType();
            if (areaType == null) {
                Constants.LOGGER.warn("Unknown area type on marking - should really not happening");
                return;
            }
            if (player.isShiftKeyDown()) {
                StickUtil.setMarkerNbt(involvedItem, marker.serializeNBT());
                StickUtil.updateStickName(involvedItem);
                return;
            }
            marker.addMarkedBlock(target);
            marker.checkValidArea();
            StickUtil.setMarkerNbt(involvedItem, marker.serializeNBT());
            StickUtil.updateStickName(involvedItem);
        }
    }

    public static void onCycleMode(Player player, ItemStack involvedItem, BlockHitResult target) {
        if (HandlerUtil.isServerSide(player.level()) && !involvedItem.equals(ItemStack.EMPTY) && StickUtil.isMarker(involvedItem)) {
            boolean targetIsAir;
            if (target.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = target.getBlockPos();
                BlockState blockstate = player.level().getBlockState(blockpos);
                targetIsAir = blockstate.getBlock().equals(Blocks.AIR);
            } else {
                boolean bl = targetIsAir = target.getType() == HitResult.Type.MISS;
            }
            if (player.isShiftKeyDown() && targetIsAir) {
                CompoundTag stickNBT = StickUtil.getStickNBT(involvedItem);
                MarkerStick marker = new MarkerStick(stickNBT);
                marker.cycleMode();
                StickUtil.setMarkerNbt(involvedItem, marker.serializeNBT());
                StickUtil.updateStickName(involvedItem);
            }
        }
    }
}

