/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import com.mojang.brigadier.ParseResults;
import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.CommandInterceptor;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Commands.class})
public abstract class CommandManagerMixin {
    @Inject(method={"performCommand"}, at={@At(value="HEAD")}, cancellable=true)
    public void execute(ParseResults<CommandSourceStack> parseResults, String command, CallbackInfo ci) {
        ServerPlayer player;
        CommandSourceStack cmdSource;
        int result = CommandInterceptor.handleModCommands(parseResults, command);
        if (result != 0) {
            ci.cancel();
        }
        if ((cmdSource = (CommandSourceStack)parseResults.getContext().getSource()).isPlayer() && (player = cmdSource.getPlayer()) != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.blockPosition(), RegionFlag.EXECUTE_COMMAND, HandlerUtil.getDimKey((Entity)player), (Player)player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                MessageSender.sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }
}

