/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.flag.FlagEvent;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.flag.IFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.flag.FlagMessage;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

final class FlagCommands {
    private FlagCommands() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAG).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.GLOBAL).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getGlobalRegion(), 0))).then(FlagCommands.flagSubCmd(ctx -> ArgumentUtil.getGlobalRegion())))).then(ArgumentUtil.literal(CommandConstants.DIM).then(FlagCommands.flagDimSubCommands()))).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(FlagCommands.flagLocalSubCommands()));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> flagDimSubCommands() {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.DIM.toString(), (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), 0))).then(FlagCommands.flagSubCmd(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, ResourceLocation> flagLocalSubCommands() {
        return (RequiredArgumentBuilder)Commands.argument((String)CommandConstants.DIM.toString(), (ArgumentType)DimensionArgument.dimension()).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), 0))).then(FlagCommands.flagSubCmd(ArgumentUtil::getRegionArgument)));
    }

    private static RequiredArgumentBuilder<CommandSourceStack, String> flagSubCmd(Function<CommandContext<CommandSourceStack>, IProtectedRegion> regionSupplier) {
        return (RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> FlagCommands.promptFlagInfo((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx)))).then(ArgumentUtil.literal(CommandConstants.INFO).executes(ctx -> FlagCommands.promptFlagInfo((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).executes(ctx -> FlagCommands.setFlagState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)CommandConstants.STATE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(FlagState.ValidFlagStates(), (SuggestionsBuilder)builder)).executes(ctx -> FlagCommands.setFlagState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getFlagStateArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.OVERRIDE).executes(ctx -> FlagCommands.setOverride((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)CommandConstants.OVERRIDE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> FlagCommands.setOverride((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getOverrideArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MSG).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MUTE).executes(ctx -> FlagCommands.setFlagMuteState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx)))).then(Commands.argument((String)CommandConstants.MUTE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> FlagCommands.setFlagMuteState((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.muteArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.SET).then(Commands.argument((String)CommandConstants.MSG.toString(), (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(FlagCommands.flagMsgExamples(), (SuggestionsBuilder)builder)).executes(ctx -> FlagCommands.setRegionFlagMsg((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getFlagMsgArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.CLEAR).executes(ctx -> FlagCommands.setRegionFlagMsg((CommandContext<CommandSourceStack>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getIFlagArgument((CommandContext<CommandSourceStack>)ctx), "config"))));
    }

    private static List<String> flagMsgExamples() {
        int amountOfExamples = 10;
        ArrayList<String> examples = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            examples.add(Component.translatableWithFallback((String)("cli.flag.msg.text.example." + i), (String)"<Your flag message here>").getString());
        }
        return examples;
    }

    private static int promptFlagInfo(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag flag) {
        if (flag == null) {
            return 1;
        }
        MultiLineMessage.send((CommandSourceStack)ctx.getSource(), MultiLineMessage.flagDetail(region, flag));
        return 0;
    }

    private static int setFlagMuteState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag;
            return FlagCommands.setFlagMuteState(ctx, region, flag, !(flag = region.getFlag(regionFlag.getName())).getFlagMsg().isMuted());
        }
        MutableComponent hint = Component.translatableWithFallback((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setFlagMuteState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag flag, boolean setMuted) {
        if (flag == null) {
            return 1;
        }
        flag.getFlagMsg().mute(setMuted);
        String muteState = flag.getFlagMsg().isMuted() ? "on" : "off";
        MutableComponent infoMsg = Component.translatableWithFallback((String)"cli.flag.msg.mute.success.text", (String)"Set mute state of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), muteState});
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!setMuted), String.valueOf(setMuted));
        MutableComponent msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setRegionFlagMsg(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag flag, String flagMsgStr) {
        if (flag == null) {
            return 1;
        }
        String oldFlagMsg = flag.getFlagMsg().msg();
        FlagEvent.UpdateFlagMessageEvent editMsgEvent = new FlagEvent.UpdateFlagMessageEvent((CommandSourceStack)ctx.getSource(), region, flag, flagMsgStr);
        Services.EVENT.post(editMsgEvent);
        FlagMessage flagMsg = new FlagMessage(flagMsgStr, flag.getFlagMsg().isMuted());
        flag.setFlagMsg(flagMsg);
        MutableComponent infoMsg = Component.translatableWithFallback((String)"cli.flag.msg.msg.success.text", (String)"Set message of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), flagMsgStr});
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), flagMsgStr, oldFlagMsg);
        MutableComponent msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setFlagState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag = region.getFlag(regionFlag.getName());
            if (flag.getState() == FlagState.ALLOWED || flag.getState() == FlagState.DENIED) {
                return FlagCommands.setFlagState(ctx, region, regionFlag, FlagState.invert(flag.getState()));
            }
            if (flag.getState() == FlagState.DISABLED) {
                return FlagCommands.setFlagState(ctx, region, regionFlag, FlagState.DENIED);
            }
            return FlagCommands.setFlagState(ctx, region, regionFlag, flag.getState());
        }
        MutableComponent hint = Component.translatableWithFallback((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setFlagState(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag flag, FlagState flagState) {
        if (flag == null) {
            return 1;
        }
        FlagState oldState = flag.getState();
        flag.setState(flagState);
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), flagState.name, oldState.name);
        MutableComponent infoMsg = Component.translatableWithFallback((String)"cli.flag.state.success.text", (String)"Set flag state of %s to: '%s'", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), flag.getState().name});
        MutableComponent msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }

    private static int setOverride(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag regionFlag) {
        if (regionFlag == null) {
            return 1;
        }
        if (region.containsFlag(regionFlag.getName())) {
            IFlag flag;
            return FlagCommands.setOverride(ctx, region, flag, !(flag = region.getFlag(regionFlag.getName())).doesOverride());
        }
        MutableComponent hint = Component.translatableWithFallback((String)"cli.msg.info.region.flag.add-hint", (String)"Add flag by clicking: %s", (Object[])new Object[]{ChatLinkBuilder.buildSuggestAddFlagLink(region)});
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.flag.not-present", (String)"Region %s does not contain flag '%s'. %", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), regionFlag.getName(), hint}));
        return 1;
    }

    private static int setOverride(CommandContext<CommandSourceStack> ctx, IProtectedRegion region, IFlag flag, boolean override) {
        if (flag == null) {
            return 1;
        }
        flag.setOverride(override);
        String overrideState = flag.doesOverride() ? "on" : "off";
        MutableComponent infoMsg = Component.translatableWithFallback((String)"cli.flag.override.success.text", (String)"Set flag override for %s to %s", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), overrideState});
        MutableComponent undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!override), String.valueOf(override));
        MutableComponent msg = Messages.substitutable("%s %s", infoMsg, undoLink);
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), msg);
        RegionManager.get().save();
        return 0;
    }
}

