/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.events.region.RegionEvent;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.DimensionCommands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public final class MarkerCommands {
    private MarkerCommands() {
    }

    static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.MARKER).then(ArgumentUtil.literal(CommandConstants.GIVE).executes(MarkerCommands::giveMarkerStick))).then(ArgumentUtil.literal(CommandConstants.RESET).executes(MarkerCommands::resetStick))).then(ArgumentUtil.literal(CommandConstants.CREATE).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Collections.singletonList(DimensionCommands.getRandomExample()), (SuggestionsBuilder)builder)).executes(ctx -> MarkerCommands.createMarkedRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), null))).then(Commands.argument((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestionsWithMarker(ctx, builder)).executes(ctx -> MarkerCommands.createMarkedRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getContainingOwnedRegionArgumentWithMarker((CommandContext<CommandSourceStack>)ctx))))));
    }

    public static IMarkableRegion fromMarkedBlocks(CommandContext<CommandSourceStack> ctx, Player player, String regionName) throws CommandSyntaxException {
        ItemStack maybeStick = player.getMainHandItem();
        if (StickUtil.isMarker(maybeStick)) {
            CompoundTag stickNBT = StickUtil.getStickNBT(maybeStick);
            if (stickNBT != null) {
                MarkerStick marker = new MarkerStick(stickNBT);
                if (!marker.isValidArea()) {
                    MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.area.invalid", (String)"Marked area is not valid").withStyle(ChatFormatting.RED));
                    return null;
                }
                return LocalRegions.regionFrom(player, marker, regionName);
            }
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.invalid", (String)"Invalid RegionMarker data, sorry. Get a new one and try again."));
            return null;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.missing", (String)"Put a valid(*) RegionMarker in your main hand to create a region!").withStyle(ChatFormatting.RED));
        return null;
    }

    private static int createMarkedRegion(CommandContext<CommandSourceStack> ctx, String regionName, IProtectedRegion parentRegion) {
        try {
            LevelRegionData levelData = RegionDataManager.getOrCreate(((CommandSourceStack)ctx.getSource()).getLevel().dimension().location());
            int res = levelData.isValidRegionName(regionName);
            if (res == -1) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.name.invalid", (String)"Invalid region name supplied: '%s'", (Object[])new Object[]{regionName}));
                return res;
            }
            if (res == 1) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.name.exists", (String)"Dimension %s already contains region with name %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(levelData.getDim()), ChatLinkBuilder.buildRegionInfoLink(levelData.getLocal(regionName))}));
                return res;
            }
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            IMarkableRegion newRegion = MarkerCommands.fromMarkedBlocks(ctx, (Player)player, regionName);
            if (newRegion == null) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.area.invalid", (String)"Marked area is not valid").withStyle(ChatFormatting.RED));
                return -1;
            }
            IProtectedRegion parent = parentRegion == null ? levelData.getDim() : parentRegion;
            return MarkerCommands.createRegion(ctx, (Player)player, levelData, newRegion, parent);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error((Object)e);
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").withStyle(ChatFormatting.RED));
            return -1;
        }
    }

    private static int createRegion(CommandContext<CommandSourceStack> ctx, Player player, LevelRegionData dimCache, IMarkableRegion region, IProtectedRegion parentRegion) {
        if (Services.EVENT.post(new RegionEvent.Create(region, player))) {
            return 1;
        }
        boolean hasConfigPermission = Permissions.get().hasConfigPermission(player);
        boolean hasRegionPermission = Permissions.get().hasGroupPermission(parentRegion, player, "owners");
        if (hasConfigPermission || hasRegionPermission) {
            Services.REGION_CONFIG.getDefaultFlags().stream().map(RegionFlag::fromId).forEach(flag -> region.addFlag(new BooleanFlag((RegionFlag)((Object)flag))));
            dimCache.addLocal(parentRegion, region);
            LocalRegions.ensureHigherRegionPriorityFor(region, Services.REGION_CONFIG.getDefaultPriority());
            RegionDataManager.save();
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.success", (String)"Successfully created region %s (parent: %s)", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), ChatLinkBuilder.buildRegionInfoLink(parentRegion)}));
            return 0;
        }
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.local.deny", (String)"You don't have the permission to create a region in the region %s!", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(parentRegion)}));
        return 1;
    }

    private static int resetStick(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack mainHandItem = player.getMainHandItem();
            if (!mainHandItem.equals(ItemStack.EMPTY) && StickUtil.isMarker(mainHandItem)) {
                StickUtil.resetMarkerNbt(mainHandItem, (ResourceKey<Level>)player.level().dimension());
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.reset", (String)"RegionMarker successfully reset!"));
                return 0;
            }
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.missing", (String)"Put a valid(*) RegionMarker in your main hand to create a region!").withStyle(ChatFormatting.RED));
            return 1;
        }
        catch (CommandSyntaxException e) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").withStyle(ChatFormatting.RED));
            return 1;
        }
    }

    private static int giveMarkerStick(CommandContext<CommandSourceStack> ctx) {
        try {
            ServerPlayer targetPlayer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack marker = Items.STICK.getDefaultInstance();
            StickUtil.initMarkerNbt(marker, (ResourceKey<Level>)targetPlayer.level().dimension());
            targetPlayer.addItem(marker);
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.success", (String)"RegionMarker added to your inventory!"));
        }
        catch (CommandSyntaxException e) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.stick.no-player", (String)"This command can only be executed as a player!").withStyle(ChatFormatting.RED));
            return 1;
        }
        return 0;
    }
}

