/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.data.region;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.MarkedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class LevelRegionData
extends SavedData {
    public static Codec<LevelRegionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(lrd -> lrd.id), (App)DimensionalRegion.CODEC.fieldOf("dim_region").forGetter(lrd -> lrd.dim), (App)Codec.unboundedMap((Codec)Codec.STRING, MarkedRegion.CODEC).optionalFieldOf("local_regions", Lifecycle.stable(), new HashMap(), Lifecycle.stable()).forGetter(lrd -> lrd.locals)).apply((Applicative)instance, LevelRegionData::new));
    private final ResourceLocation id;
    private HashMap<String, IMarkableRegion> locals;
    private DimensionalRegion dim;

    public static SavedDataType<LevelRegionData> buildSavedDataType(ResourceLocation dimRl) {
        String dimId = dimRl.toString().replace(':', '_');
        return new SavedDataType(String.join((CharSequence)"/", "yawp", dimId), ctx -> new LevelRegionData(dimRl), ctx -> CODEC, null);
    }

    public LevelRegionData(ResourceLocation id, DimensionalRegion dim, Map<String, IMarkableRegion> locals) {
        this(id);
        this.dim = dim;
        this.locals.putAll(locals);
    }

    public LevelRegionData(ResourceLocation id, DimensionalRegion dim) {
        this(id);
        this.dim = dim;
        this.locals = new HashMap();
    }

    public LevelRegionData(ResourceLocation id) {
        this.id = id;
        this.locals = new HashMap();
        GlobalRegion global = RegionManager.get().getGlobalRegion();
        ResourceKey levelRk = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
        this.dim = new DimensionalRegion((ResourceKey<Level>)levelRk, global);
    }

    public HashMap<String, IMarkableRegion> getLocals() {
        return this.locals;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceKey<Level> getDimKey() {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.getId());
    }

    public int regionCount() {
        return this.locals.size();
    }

    public Collection<IMarkableRegion> getLocalList() {
        return this.locals.values().stream().toList();
    }

    public Collection<String> getLocalNames() {
        return this.locals.keySet().stream().toList();
    }

    public DimensionalRegion getDim() {
        return this.dim;
    }

    public void renameLocal(IMarkableRegion region, String regionName) {
        if (this.locals.containsKey(regionName)) {
            throw new IllegalArgumentException("Region with name '" + regionName + "' already exists in dimension '" + this.dim.getName() + "'!");
        }
        IMarkableRegion currentRegion = this.locals.get(region.getName());
        IProtectedRegion parent = currentRegion.getParent();
        this.removeLocal(currentRegion);
        currentRegion.rename(regionName);
        this.addLocal(parent, currentRegion);
    }

    public int isValidRegionName(String regionName) {
        List commandStrings = Arrays.stream(CommandConstants.values()).map(CommandConstants::toString).collect(Collectors.toList());
        if (!regionName.matches(RegionArgumentType.VALID_NAME_PATTERN.pattern()) || commandStrings.contains(regionName.toLowerCase())) {
            return -1;
        }
        if (this.locals.containsKey(regionName)) {
            return 1;
        }
        return 0;
    }

    public void addLocal(IProtectedRegion parent, IMarkableRegion child) {
        parent.addChild(child);
        this.locals.put(child.getName(), child);
    }

    public void addLocal(IMarkableRegion child) {
        this.dim.addChild(child);
        this.locals.put(child.getName(), child);
    }

    public void removeLocal(IMarkableRegion region) {
        if (this.hasLocal(region.getName())) {
            this.locals.remove(region.getName());
            if (region.getParent().getRegionType() == RegionType.DIMENSION) {
                region.getParent().removeChild(region);
            }
        }
    }

    public boolean hasLocal(String regionName) {
        return this.locals.containsKey(regionName);
    }

    public IMarkableRegion getLocal(String regionName) {
        return this.locals.get(regionName);
    }

    public void clearLocals() {
        this.locals.clear();
        this.dim.clearChildren();
    }
}

