/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.flag.FlagCorrelation;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionFlagPagination;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ResponsibleFlagPagination
extends BasePaginationMessage<FlagCorrelation> {
    private final IProtectedRegion region;

    public ResponsibleFlagPagination(IProtectedRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(ResponsibleFlagPagination.getCorrelations(region), Commands.buildListFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static MutableComponent buildRegionFlagInfoHeader(IProtectedRegion region, MutableComponent flagListLink) {
        return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static List<Component> buildRegionFlagEntries(IProtectedRegion region) {
        return ResponsibleFlagPagination.buildRegionFlagEntries(region, region.getFlags().flags().stream().toList());
    }

    public static List<Component> buildRegionFlagEntries(IProtectedRegion region, List<IFlag> selectedFlags) {
        ArrayList<Component> flagEntries = new ArrayList<Component>();
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DENIED));
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.ALLOWED));
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntriesForState(region, selectedFlags, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<MutableComponent> buildFlagEntriesForState(IProtectedRegion region, List<IFlag> selectedFlags, FlagState state) {
        List<IFlag> flagsByState = selectedFlags.stream().filter(f -> f.getState() == state).sorted(Comparator.comparing(IFlag::getName)).toList();
        return flagsByState.stream().map(flag -> ResponsibleFlagPagination.buildRemoveFlagEntry(region, flag, ResponsibleFlagPagination.colorForState(flag.getState()), new ChatFormatting[0])).collect(Collectors.toList());
    }

    public static MutableComponent buildRemoveFlagEntry(IProtectedRegion region, IFlag flag, ChatFormatting flagLinkColor, ChatFormatting ... ChatFormattings) {
        String cmd = switch (region.getRegionType()) {
            case RegionType.GLOBAL -> Commands.buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.DIMENSION -> Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().location().toString(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            case RegionType.LOCAL -> Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().location().toString(), region.getName(), CommandConstants.REMOVE.toString(), CommandConstants.FLAG.toString(), flag.getName());
            default -> throw new IllegalArgumentException();
        };
        MutableComponent hoverText = Component.translatableWithFallback((String)"cli.msg.info.region.flag.remove.link.hover", (String)"Remove flag '%s' from region %s", (Object[])new Object[]{flag.getName(), region.getName()});
        MutableComponent linkText = Component.translatableWithFallback((String)"cli.link.remove", (String)"x");
        MutableComponent flagRemoveLink = ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
        MutableComponent flagQuickActionComponent = RegionFlagPagination.buildFlagQuickActionComponent(region, flag, flagLinkColor);
        flagQuickActionComponent.withStyle(ChatFormattings);
        return Messages.substitutable(" - %s %s", flagRemoveLink, flagQuickActionComponent);
    }

    public static ChatFormatting colorForState(FlagState state) {
        switch (state) {
            case ALLOWED: {
                return ChatFormatting.GREEN;
            }
            case DENIED: {
                return ChatFormatting.RED;
            }
            case DISABLED: {
                return ChatFormatting.GRAY;
            }
        }
        throw new IllegalArgumentException();
    }

    public static List<MutableComponent> buildFlagEntries(IProtectedRegion region) {
        ArrayList<MutableComponent> flagEntries = new ArrayList<MutableComponent>();
        Map<String, FlagCorrelation> flagMapRecursive = HandlerUtil.getFlagMapRecursive(region, null);
        Map<FlagState, List<FlagCorrelation>> flagStateListMap = ResponsibleFlagPagination.sortFlagsByState(flagMapRecursive);
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntries(flagStateListMap, FlagState.ALLOWED));
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntries(flagStateListMap, FlagState.DENIED));
        flagEntries.addAll(ResponsibleFlagPagination.buildFlagEntries(flagStateListMap, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<Component> buildFlagEntries(List<FlagCorrelation> flags) {
        return flags.stream().map(fc -> ResponsibleFlagPagination.buildRemoveFlagEntry(fc.region(), fc.flag(), ResponsibleFlagPagination.colorForState(fc.flag().getState()), new ChatFormatting[0])).collect(Collectors.toList());
    }

    public static List<MutableComponent> buildFlagEntries(Map<FlagState, List<FlagCorrelation>> flagStateListMap, FlagState state) {
        List<FlagCorrelation> flagsByState = flagStateListMap.get((Object)state);
        flagsByState.sort(Comparator.comparing(flagCorrelation -> flagCorrelation.flag().getName()));
        return flagsByState.stream().map(flagCorrelation -> ResponsibleFlagPagination.buildRemoveFlagEntry(flagCorrelation.region(), flagCorrelation.flag(), ResponsibleFlagPagination.colorForState(state), new ChatFormatting[0])).collect(Collectors.toList());
    }

    public static Map<FlagState, List<IFlag>> sortFlagsByState(IProtectedRegion region) {
        HashMap<FlagState, List<IFlag>> flagStateListMap = new HashMap<FlagState, List<IFlag>>();
        flagStateListMap.put(FlagState.DENIED, region.getFlags().flags(FlagState.DENIED));
        flagStateListMap.put(FlagState.ALLOWED, region.getFlags().flags(FlagState.ALLOWED));
        flagStateListMap.put(FlagState.DISABLED, region.getFlags().flags(FlagState.DISABLED));
        return flagStateListMap;
    }

    public static Map<FlagState, List<FlagCorrelation>> sortFlagsByState(Map<String, FlagCorrelation> flagMap) {
        HashMap<FlagState, List<FlagCorrelation>> flagStateListMap = new HashMap<FlagState, List<FlagCorrelation>>();
        flagStateListMap.put(FlagState.DENIED, ResponsibleFlagPagination.getCorrelationByState(flagMap, FlagState.DENIED));
        flagStateListMap.put(FlagState.ALLOWED, ResponsibleFlagPagination.getCorrelationByState(flagMap, FlagState.ALLOWED));
        flagStateListMap.put(FlagState.DISABLED, ResponsibleFlagPagination.getCorrelationByState(flagMap, FlagState.DISABLED));
        return flagStateListMap;
    }

    public static List<FlagCorrelation> getCorrelations(IProtectedRegion region) {
        Map<String, FlagCorrelation> flagMap = HandlerUtil.getFlagMapRecursive(region, null);
        return flagMap.values().stream().filter(c -> c.flag() != null).sorted(Comparator.comparing(c -> c.flag().getState())).sorted(Comparator.comparing(c -> c.flag().getName())).collect(Collectors.toList());
    }

    private static List<FlagCorrelation> getCorrelationByState(Map<String, FlagCorrelation> flagMap, FlagState state) {
        return flagMap.values().stream().filter(c -> c.flag() != null).filter(c -> c.flag().getState() == state).sorted(Comparator.comparing(c -> c.flag().getName())).collect(Collectors.toList());
    }

    @Override
    public Component noContentMsg() {
        return Component.translatableWithFallback((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public Component header() {
        return ResponsibleFlagPagination.buildRegionFlagInfoHeader(this.region, ChatLinkBuilder.buildRegionFlagListLink(this.region));
    }

    @Override
    public List<Component> buildEntries() {
        return ResponsibleFlagPagination.buildFlagEntries(this.pageContent);
    }

    @Override
    public Component emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildSuggestAddFlagLink(this.region));
    }
}

