package de.z0rdak.yawp.api.permission;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;

public final class Permissions {

    public final static String MEMBER = "members";
    public final static String OWNER = "owners";
    public final static List<String> GROUP_LIST = Arrays.asList(MEMBER, OWNER);

    private Permissions(){}
    
    private static final Permissions permission = new Permissions();
    public static Permissions get() {
        return permission;
    }
    /**
     * Permission needs to be separately handled for
     * - using commands
     * - modifying region properties
     */

    public static List<String> getGroups(IProtectedRegion region, class_1657 player) {
        return GROUP_LIST;
    }

    public boolean hasConfigPermAndOpBypassFlags(class_1657 player) {
        boolean byPassFlagAllowed = PermissionConfig.byPassFlagAllowed();
        boolean hasConfigPerm = PermissionConfig.hasConfigPermission(player);
        return hasConfigPerm && byPassFlagAllowed;
    }
    
    public boolean hasConfigPermission(class_2168 src, CommandSourceType srcType) throws CommandSyntaxException {
        return PermissionConfig.hasConfigPermission(src, srcType);
    }

    public boolean hasConfigPermission(class_1657 player) {
        return PermissionConfig.hasConfigPermission(player);
    }

    public boolean hasOwnerPermission(IProtectedRegion region, class_1657 player) {
        return hasGroupPermission(region, player, OWNER);
    }

    public boolean hasAnyPermission(IProtectedRegion region, class_1657 player, List<String> groups) {
        return groups.stream()
                .map(group -> hasGroupPermission(region, player, group))
                .reduce(false, (b1, b2) -> b1 || b2);
    }

    public boolean hasCmdPermission(class_2168 src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            return PermissionConfig.hasConfigPermission(src, cmdSrcType);
        } catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean isAllowedForNonOp(class_2168 src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            boolean hasConfigPerm = PermissionConfig.hasConfigPermission(src, cmdSrcType);
            return hasConfigPerm || PermissionConfig.isCmdEnabledForNonOp();
        } catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean hasGroupPermission(IProtectedRegion region, class_1657 player, String permissionGroup) {
        return PermissionConfig.isHierarchyOwnershipEnabled()
                ? hasRegionHierarchyPermission(region, player, permissionGroup)
                : isInGroup(region, player, permissionGroup);
    }

    public boolean isInGroup(IProtectedRegion region, class_1657 player, String group) {
        return region.isInGroup(player, group);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, class_1657 player, String permissionGroup) {
        return hasRegionHierarchyPermission(region, player, permissionGroup, false);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, class_1657 player, String permissionGroup, boolean hasPermission) {
        if (region.getParent().equals(region)) {
            return hasPermission || isInGroup(region, player, permissionGroup);
        }
        hasPermission = hasPermission || isInGroup(region, player, permissionGroup);
        return hasRegionHierarchyPermission(region.getParent(), player, permissionGroup, hasPermission);
    }

}
