package de.z0rdak.yawp.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class DimensionCacheArgumentType implements ArgumentType<DimensionRegionCache> {

    private static final Collection<String> EXAMPLES = RegionDataManager.get().getDimensionList();

    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(
            dim -> class_2561.method_48322("cli.arg.dim.invalid", "Dimension '%s' does not exist!", dim)
    );

    private static DimensionRegionCache getDimensionalRegionCache(class_2960 resourcelocation) {
        // TODO: Check valid dimension key?
        class_5321<class_1937> registrykey = class_5321.method_29179(class_7924.field_41223, resourcelocation);
        if (RegionDataManager.get().containsCacheFor(registrykey)) {
            return RegionDataManager.get().cacheFor(registrykey);
        } else {
            DimensionRegionCache newCache = RegionDataManager.get().newCacheFor(registrykey);
            RegionDataManager.save();
            return newCache;
        }
    }

    public static DimensionCacheArgumentType dimRegion() {
        return new DimensionCacheArgumentType();
    }

    public static DimensionRegionCache getDimRegion(CommandContext<class_2168> context, String dim) throws CommandSyntaxException {
        class_2960 resourcelocation = context.getArgument(dim, class_2960.class);
        boolean isValidDimResourceLocation = context.getSource().method_29310().stream()
                .map(class_5321::method_29177)
                .anyMatch(loc -> loc.equals(resourcelocation));
        if (isValidDimResourceLocation) {
            DimensionRegionCache dimCache = getDimensionalRegionCache(resourcelocation);
            if (dimCache == null) {
                throw ERROR_INVALID_VALUE.create(resourcelocation.toString());
            }
            return dimCache;
        } else {
            throw ERROR_INVALID_VALUE.create(resourcelocation.toString());
        }
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            return class_2172.method_9265(RegionDataManager.get().getDimensionList(), builder);
        } else {
            return Suggestions.empty();
        }
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Override
    public DimensionRegionCache parse(StringReader reader) throws CommandSyntaxException {
        class_2960 resourcelocation = class_2960.method_12835(reader);
        class_5321<class_1937> registrykey = class_5321.method_29179(class_7924.field_41223, resourcelocation);
        if (RegionDataManager.get().containsCacheFor(registrykey)) {
            return RegionDataManager.get().cacheFor(registrykey);
        }
        return null;
    }
}
