package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.INbtSerializable;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;

/**
 * IMarkableArea provides an interface for different types of areas.
 * The most basic area would be a simple AxisAlignedBB.
 * This type of mark-able area is already implemented in the class CuboidArea.
 */
public interface IMarkableArea extends INbtSerializable<class_2487> {

    boolean contains(class_2338 pos);

    AreaType getAreaType();

    List<class_2338> markedBlocks();

    Set<class_2338> getHull();

    boolean containsOther(IMarkableArea other);

    boolean intersects(IMarkableArea other);
}
