package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.constants.serialization.RegionNbtKeys;
import org.apache.commons.lang3.NotImplementedException;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class Polygon3DArea extends AbstractArea {

    private List<class_2338> positions;

    private Polygon3DArea() {
        super(AreaType.POLYGON_3D);
        this.positions = new ArrayList<>();
    }

    public Polygon3DArea(List<class_2338> positions) {
        this();
        this.positions = positions;
    }

    public Polygon3DArea(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    /**
     * <a href="https://www.eecs.umich.edu/courses/eecs380/HANDOUTS/PROJ2/InsidePoly.html">...</a>
     *
     * @param q
     * @param posList
     * @param n
     * @return
     */
    private static double calcAngleSum(class_2338 q, List<class_2338> posList, int n) {
        final double ESPILON = 0.0000001;
        double m1, m2, cosTheta, angleSum = 0;
        class_2338 p1, p2;
        for (int i = 0; i < n; i++) {
            p1 = posList.get(i).method_10059(q);
            p2 = posList.get((i + 1) % n).method_10059(q);
            m1 = modulus(p1);
            m2 = modulus(p2);
            if (m1 * m2 <= ESPILON) {
                return 2 * Math.PI; /* We are on a node, consider this inside */
            } else {
                cosTheta = (p1.method_10263() * p2.method_10263() + p1.method_10264() * p2.method_10264() + p1.method_10260() * p2.method_10260() / (m1 * m2));
            }
            angleSum += Math.acos(cosTheta);
        }
        return angleSum;
    }

    private static double modulus(class_2338 p) {
        return Math.sqrt(p.method_10263() * p.method_10263() + p.method_10264() * p.method_10264() + p.method_10260() * p.method_10260());
    }

    public List<class_2338> getPositions() {
        return Collections.unmodifiableList(positions);
    }

    @Override
    public boolean contains(class_2338 q) {
        return calcAngleSum(q, this.positions, this.positions.size()) == 2 * Math.PI;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        class_2499 pointList = new class_2499();
        this.positions.forEach((point) -> {
            class_2520 pointNbt = class_2512.method_10692(point);
            pointList.add(pointNbt);
        });
        nbt.method_10566(RegionNbtKeys.BLOCKS, pointList);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.positions.clear();
        this.deserializeNBT(nbt);
        class_2499 pointList = nbt.method_10554(RegionNbtKeys.BLOCKS, class_2520.field_33260);
        for (int i = 0; i < pointList.size(); i++) {
            // FIXME-ALPHA
            //BlockPos pos = NbtUtils.readBlockPos(pointList.getCompound(i));
            //this.positions.add(pos);
        }
    }

    @Override
    public String toString() {
        throw new NotImplementedException("Missing toString");
    }

    @Override
    public List<class_2338> markedBlocks() {
        return this.positions;
    }

    @Override
    public Set<class_2338> getHull() {
        throw new NotImplementedException("ChunkArea.getHull() not implemented yet");
    }


    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }
}
