package de.z0rdak.yawp.core.flag;

import static de.z0rdak.yawp.constants.serialization.RegionNbtKeys.*;

import net.minecraft.class_2487;

public abstract class AbstractFlag implements IFlag {

    protected String name;
    protected FlagType type;
    protected FlagState state;
    protected boolean doesOverride;
    protected FlagMessage msg;

    public AbstractFlag(String name, FlagType type, boolean override) {
        this(name, type, override, FlagState.DENIED);
    }

    public AbstractFlag(String name, FlagType type, boolean override, FlagState state) {
        this.name = name;
        this.type = type;
        this.state = state;
        this.doesOverride = override;
        this.msg = FlagMessage.DEFAULT_FLAG_MSG;
    }

    public AbstractFlag(String name, FlagType type) {
        this(name, type, false, FlagState.DENIED);
    }

    public AbstractFlag(String name, FlagType type, boolean override, FlagState state, String msg) {
        this(name, type, override, state);
        this.msg = new FlagMessage(msg);
    }

    public AbstractFlag(class_2487 nbt) {
        this.deserializeNBT(nbt);
    }

    @Override
    public FlagType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActive() {
        return this.state == FlagState.ALLOWED || this.state == FlagState.DENIED;
    }

    @Override
    public FlagState getState() {
        return this.state;
    }

    @Override
    public void setState(FlagState state) {
        this.state = state;
    }

    @Override
    public boolean doesOverride() {
        return this.doesOverride;
    }

    @Override
    public void setOverride(boolean override) {
        this.doesOverride = override;
    }

    @Override
    public FlagMessage getFlagMsg() {
        return this.msg;
    }

    @Override
    public void setFlagMsg(FlagMessage msg) {
        this.msg = msg;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10582(FLAG_NAME, this.name);
        nbt.method_10582(FLAG_STATE, this.state.name);
        nbt.method_10556(OVERRIDE, this.doesOverride);
        nbt.method_10582(FLAG_TYPE, this.type.flagType);
        nbt.method_10566(FLAG_MSG, this.msg.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.name = nbt.method_10558(FLAG_NAME);
        // Note: this is here for compatibility for the jump from 0.0.3.0-beta1 to 0.0.4.0-beta1
        // The state was not saved in the nbt before, there was a boolean flag instead
        if (nbt.method_10545(FLAG_STATE)) {
            this.state = FlagState.from(nbt.method_10558(FLAG_STATE));
        } else {
            if (nbt.method_10545(FLAG_ACTIVE)) {
                boolean active = nbt.method_10577(FLAG_ACTIVE);
                if (active) {
                    this.state = FlagState.DENIED;
                } else {
                    this.state = FlagState.DISABLED;
                }
            } else {
                this.state = FlagState.DISABLED;
            }
        }
        this.doesOverride = nbt.method_10577(OVERRIDE);
        this.type = FlagType.of(nbt.method_10558(FLAG_TYPE));
        this.msg = new FlagMessage(nbt.method_10562(FLAG_MSG));
    }

    @Override
    public int compareTo(IFlag o) {
        int nameComparisonRes = this.name.compareTo(o.getName());
        int stateResult = this.state.compareTo(o.getState());
        return nameComparisonRes + stateResult;
    }
}
