package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.NbtCompatHelper;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_5321;

import static de.z0rdak.yawp.constants.serialization.RegionNbtKeys.*;

/**
 * The AbstractMarkableRegion represents an abstract implementation for a markable region.
 * This can be used to implement different types of regions which define their area in a different way.
 */
public abstract class AbstractMarkableRegion extends AbstractRegion implements IMarkableRegion {

    protected int priority;
    protected IMarkableArea area;
    protected AreaType areaType;
    protected class_2338 tpTarget;

    public AbstractMarkableRegion(String name, IMarkableArea area, class_1657 owner, class_5321<class_1937> dimension, AbstractRegion parent) {
        super(name, dimension, RegionType.LOCAL, owner);
        this.area = area;
        this.areaType = area.getAreaType();
        this.priority = Services.REGION_CONFIG.getDefaultPriority();
        if (parent != null) {
            this.setParent(parent);
        }
    }

    public AbstractMarkableRegion(String name, IMarkableArea area, class_1657 owner, class_5321<class_1937> dimension) {
        this(name, area, owner, dimension, null);
    }

    public AbstractMarkableRegion(String name, IMarkableArea area, class_2338 tpTarget, class_1657 owner, class_5321<class_1937> dimension) {
        this(name, area, owner, dimension, null);
        this.tpTarget = tpTarget;
    }

    public AbstractMarkableRegion(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    @Override
    protected boolean setParent(IProtectedRegion parent) {
        if (this.parent == null) {
            boolean isParentLocalOrDim = parent.getRegionType() == RegionType.DIMENSION || parent.getRegionType() == RegionType.LOCAL;
            return isParentLocalOrDim && super.setParent(parent);
        } else {
            if (this.parent.getRegionType() == RegionType.LOCAL && parent.getRegionType() == RegionType.DIMENSION) {
                return super.setParent(parent);
            }
            if (this.parent.getRegionType() == RegionType.DIMENSION && parent.getRegionType() == RegionType.LOCAL) {
                return super.setParent(parent);
            }
        }
        return false;
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        if (child.getRegionType() == RegionType.LOCAL && child.getParent() == null) {
            return super.addChild(child);
        }
        if (child.getRegionType() == RegionType.LOCAL && child.getParent().getRegionType() == RegionType.DIMENSION) {
            return super.addChild(child);
        }
        return false;
    }

    @Override
    public boolean contains(class_2338 position) {
        return this.area.contains(position);
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10566(TP_POS, class_2512.method_10692(this.tpTarget));
        nbt.method_10569(PRIORITY, priority);
        nbt.method_10582(AREA_TYPE, this.areaType.areaType);
        nbt.method_10566(AREA, this.area.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.tpTarget = NbtCompatHelper.toBlockPos(nbt, TP_POS).orElseThrow();
        this.priority = nbt.method_10550(PRIORITY);
        AreaType areaType = AreaType.of(nbt.method_10558(AREA_TYPE));
        if (areaType == null) {
            Constants.LOGGER.error("Error loading region data for: '{}' in dim '{}'", this.getName(), this.dimension.method_29177());
            throw new IllegalArgumentException("Error loading region data for: '" + this.getName() + "' in dim '" + this.dimension.method_29177() + "'");
        }
        this.areaType = areaType;
    }

    @Override
    public IMarkableArea getArea() {
        return area;
    }

    @Override
    public void setArea(IMarkableArea area) {
        this.area = area;
    }

    @Override
    public void rename(String newName) {
        this.setName(newName);
    }

    @Override
    public int getPriority() {
        return priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    public AreaType getAreaType() {
        return areaType;
    }

    @Override
    public class_2338 getTpTarget() {
        return tpTarget;
    }

    @Override
    public void setTpTarget(class_2338 tpTarget) {
        this.tpTarget = tpTarget;
    }
}
