package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.constants.serialization.RegionNbtKeys;
import de.z0rdak.yawp.core.area.CuboidArea;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_5321;

/**
 * A cuboid regions represents it's area as a simple rectangular cuboid (a BlockBox).
 * The region is marked with two blocks representing the bounding box of the area.
 */
public final class CuboidRegion extends AbstractMarkableRegion {

    public CuboidRegion(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    public CuboidRegion(String name, CuboidArea area, class_5321<class_1937> dim) {
        super(name, area, area.getArea().method_22874(), null, dim);
    }

    public CuboidRegion(String name, CuboidArea area, class_1657 owner, class_5321<class_1937> dimension) {
        super(name, area, area.getArea().method_22874(), owner, dimension);
    }

    public CuboidRegion(String name, CuboidArea area, class_2338 tpPos, class_1657 owner, class_5321<class_1937> dimension) {
        super(name, area, tpPos, owner, dimension);
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.area = new CuboidArea(nbt.method_10562(RegionNbtKeys.AREA));
    }
}
