package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.constants.serialization.RegionNbtKeys;
import de.z0rdak.yawp.core.area.SphereArea;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_5321;

public final class SphereRegion extends AbstractMarkableRegion {

    public SphereRegion(class_2487 nbt) {
        super(nbt);
        this.deserializeNBT(nbt);
    }

    public SphereRegion(String name, SphereArea area, class_5321<class_1937> dimension) {
        this(name, area, area.getCenterPos(), null, dimension);
    }

    public SphereRegion(String name, SphereArea area, class_1657 owner, class_5321<class_1937> dimension) {
        super(name, area, area.getCenterPos(), owner, dimension);
    }

    public SphereRegion(String name, SphereArea area, class_2338 tpPos, class_1657 player, class_5321<class_1937> dimension) {
        super(name, area, tpPos, player, dimension);
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.area = new SphereArea(nbt.method_10562(RegionNbtKeys.AREA));
    }
}
