package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1560;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.ENDERMAN_TELEPORT_FROM_REGION;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1560.class)
public abstract class EnderManEntityMixin {
    @Inject(method = "teleport(DDD)Z", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onEndermanTeleport(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        class_1560 self = (class_1560) (Object) this;
        if (isServerSide(self.method_37908())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), ENDERMAN_TELEPORT_FROM_REGION, getDimKey(self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(false);
            });
        }
    }
}
