package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {

    @Unique
    @Nullable
    protected class_1657 attackingPlayer;

    @Inject(method = "knockback", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onKnockback(double strength, double x, double z, CallbackInfo ci) {
        class_1309 target = (class_1309) (Object) this;
        if (isServerSide(target)) {
            if (target instanceof class_1657) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), KNOCKBACK_PLAYERS, getDimKey(target));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    ci.cancel();
                });
                checkEvent = new FlagCheckEvent(target.method_24515(), INVINCIBLE, getDimKey(target));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    ci.cancel();
                });
            }
        }
    }

    // FIXME: Separate flags for dropLoot -> mobs, etc AND dropInventory ->
    @Inject(method = "dropAllDeathLoot", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onDrop(class_3218 level, class_1282 source, CallbackInfo ci) {
        class_1309 target = (class_1309) (Object) this;
        if (isServerSide(target)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), DROP_LOOT_ALL, getDimKey(target));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, deny -> {
                ci.cancel();
            });
            if (source.method_5529() instanceof class_1657 player) {
                checkEvent = new FlagCheckEvent(target.method_24515(), DROP_LOOT_PLAYER, getDimKey(target), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            }
        }
    }

    @Inject(method = "causeFallDamage", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309) (Object) this;
        if (isServerSide(self)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), FALL_DAMAGE, getDimKey(self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, deny -> {
                cir.setReturnValue(false);
            });
            if (isMonster(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), FALL_DAMAGE_MONSTERS, getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    cir.setReturnValue(false);
                });
            }
            if (isAnimal(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), FALL_DAMAGE_ANIMALS, getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    cir.setReturnValue(false);
                });
            }
            if (isVillager(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), FALL_DAMAGE_VILLAGERS, getDimKey(self));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    cir.setReturnValue(false);
                });
            }
            if (isPlayer(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), FALL_DAMAGE_PLAYERS, getDimKey(self), (class_1657) self);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(false);
                });
            }
        }
    }

    @Inject(method = "dropExperience", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"), cancellable = true, allow = 1)
    public void onXpDrop(CallbackInfo ci) {
        class_1309 self = (class_1309) (Object) this;
        if (this.attackingPlayer != null) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), XP_DROP_ALL, getDimKey(self));
            if (Services.EVENT.post(checkEvent))
                return;
            processCheck(checkEvent, deny -> {
                ci.cancel();
            });
            
            // if this entity is killed by a player, prevent xp dropping
            checkEvent = new FlagCheckEvent(self.method_24515(), XP_DROP_PLAYER, getDimKey(self), this.attackingPlayer);
            if (Services.EVENT.post(checkEvent))
                return;
            processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                ci.cancel();
            });
            
            if (isMonster(self)) {
                checkEvent = new FlagCheckEvent(self.method_24515(), XP_DROP_MONSTER, getDimKey(self));
                if (Services.EVENT.post(checkEvent))
                    return;
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            } else {
                checkEvent = new FlagCheckEvent(self.method_24515(), XP_DROP_OTHER, getDimKey(self));
                if (Services.EVENT.post(checkEvent))
                    return;
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            }
        }
        
        if (self instanceof class_1657) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.KEEP_XP, getDimKey(self));
            if (Services.EVENT.post(checkEvent))
                return;
            processCheck(checkEvent, deny -> {
                ci.cancel();
            });
        }
    }

    /**
     * If a corresponding flag is set, this injection prevents the placing of a wither rose as a block and drops it as ItemEntity
     * as vanilla would do it when the gamerule doMobgrief is set to false
     */
    @Inject(method = "createWitherRose", locals = LocalCapture.CAPTURE_FAILSOFT,
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"), cancellable = true, allow = 1)
    public void onCreateWitherRose(@Nullable class_1309 adversary, CallbackInfo ci, class_3218 level, boolean bl, class_2338 pos, class_2680 blockState) {
        class_1309 self = (class_1309) (Object) this;
        class_1937 world = self.method_37908();
        if (isServerSide(world)) {
            class_3218 serverLevel = (class_3218) self.method_37908();
            if (adversary instanceof class_1528) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(pos, MOB_GRIEFING, serverLevel.method_27983(), null);
                if (Services.EVENT.post(checkEvent))
                    return;
                processCheck(checkEvent, deny -> {
                    // prevent the rose to be placed as block, but spawn it as item-entity as vanilla does it
                    ci.cancel();
                    class_1542 itemEntity = new class_1542(serverLevel, self.method_23317(), self.method_23318(), self.method_23321(), new class_1799(class_1802.field_17515));
                    serverLevel.method_8649(itemEntity);
                });
            }
        }
    }
}
