package de.z0rdak.yawp.mixin.flag.mobgrief;


import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1308;
import net.minecraft.class_1343;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.MOB_GRIEFING;
import static de.z0rdak.yawp.core.flag.RegionFlag.ZOMBIE_DOOR_PROT;
import static de.z0rdak.yawp.handler.HandlerUtil.*;


@Mixin(net.minecraft.class_1339.class)
public abstract class BreakDoorGoal extends class_1343 {
    public BreakDoorGoal(class_1308 mob) {
        super(mob);
    }

    @Inject(method = "canUse", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onCanStart(CallbackInfoReturnable<Boolean> cir) {
        if (isServerSide(field_6413.method_37908())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(field_6413.method_24515(), ZOMBIE_DOOR_PROT, getDimKey(field_6413));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, deny -> {
                cir.setReturnValue(false);
            });

            checkEvent = new FlagCheckEvent(field_6413.method_24515(), MOB_GRIEFING, getDimKey(field_6413));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, deny -> {
                cir.setReturnValue(null);
            });
        }
    }
}
